<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Commande;
use App\Models\Product;
use App\Models\User;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'total_orders' => Commande::count(),
            'pending_orders' => Commande::where('statut', 'en_attente')->count(),
            'processing_orders' => Commande::where('statut', 'en_cours')->count(),
            'total_products' => Product::count(),
            'low_stock' => Product::where('en_stock', '<', 5)->count(),
            'total_users' => User::where('role', 'client')->count(),
            'total_revenue' => Commande::where('statut', 'livres')->sum('total'),
        ];

        $recent_orders = Commande::with('user')
            ->orderBy('created_at', 'desc')
            ->limit(10)
            ->get();

        $low_stock_products = Product::where('en_stock', '<', 5)
            ->with('category')
            ->orderBy('en_stock', 'asc')
            ->limit(10)
            ->get();

        return view('admin.dashboard', compact('stats', 'recent_orders', 'low_stock_products'));
    }
}
