<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Commande extends Model
{
    protected $table = 'commandes';
    public $timestamps = false; // Only created_at exists

    protected $fillable = [
        'user_id',
        'name_client',
        'prenom_client',
        'telephone_client',
        'adresse_client',
        'total',
        'created_at',
        'statut'
    ];

    protected $casts = [
        'created_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function products()
    {
        return $this->belongsToMany(Product::class, 'order_items', 'commande_id', 'product_id')
                    ->withPivot('quantite', 'prix_unitaire');
    }

    public function items()
    {
        return $this->hasMany(OrderItem::class, 'commande_id');
    }
}
