<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Login extends Model
{
    protected $table = 'login';
    public $timestamps = false;

    protected $fillable = [
        'user_id',
        'isblocked',
        'isConnected',
        'last_login'
    ];

    protected $casts = [
        'isblocked' => 'boolean',
        'isConnected' => 'boolean',
        'last_login' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
