<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class OrderItem extends Model
{
    protected $table = 'order_items';
    public $timestamps = false;

    protected $fillable = [
        'commande_id',
        'product_id',
        'quantite',
        'prix_unitaire'
    ];

    public function order()
    {
        return $this->belongsTo(Commande::class, 'commande_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }
}
