<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $table = 'products';
    public $timestamps = true;

    protected $fillable = [
        'name',
        'category_id',
        'description',
        'image',
        'marque',
        'type_pneu',
        'dot_annee',
        'prix_actuel',
        'prix_ancien',
        'pays_fabrication',
        'largeur',
        'hauteur',
        'diametre',
        'dimension',
        'charge_index',
        'vitesse_index',
        'vitesse_kmh',
        'saison',
        'runflat',
        'renforce',
        'conso_carburant',
        'adherence_sol_mouille',
        'bruit_externe_db',
        'sku',
        'en_stock'
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    /**
     * The "booted" method of the model.
     *
     * @return void
     */
    protected static function booted()
    {
        static::deleting(function ($product) {
            if ($product->image) {
                \Illuminate\Support\Facades\Storage::disk('public')->delete('pneus/' . $product->image);
            }
        });
    }
}
