<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        if (\Schema::hasTable('categories')) {
            $categories = \App\Models\Category::all();
            \Illuminate\Support\Facades\View::share('globalCategories', $categories);
        }

        if (\Schema::hasTable('users')) {
            $admin = \App\Models\User::where('role', 'admin')->first();
            \Illuminate\Support\Facades\View::share('adminContact', $admin);
        }

        Paginator::useBootstrapFive();
    }
}
