<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pneus', function (Blueprint $table) {
            $table->id();
            $table->string('nom_pneu', 255);
            $table->string('marque', 255);

            $table->enum('type_pneu', [
                'Tourisme','4x4 / SUV','Camionnette / Utilitaire'
            ]);

            $table->integer('dot_annee')->nullable();
            $table->decimal('prix_actuel', 10, 2);
            $table->decimal('prix_ancien', 10, 2)->nullable();
            $table->string('pays_fabrication', 100)->nullable();

            $table->integer('largeur')->nullable();
            $table->integer('hauteur')->nullable();
            $table->string('diametre', 10)->nullable();
            $table->string('dimension', 50);

            $table->integer('charge_index')->nullable();
            $table->string('vitesse_index', 10)->nullable();
            $table->string('vitesse_kmh', 50)->nullable();

            $table->string('adherence_sol_mouille', 1)->nullable();
            $table->integer('bruit_externe_db')->nullable();
            $table->string('sku', 100)->nullable();

            $table->boolean('runflat')->default(0);
            $table->boolean('renforce')->default(0);
            $table->char('conso_carburant', 1)->nullable();

            $table->enum('saison', ['4 Saisons','Été','Hiver']);
            $table->integer('en_stock')->default(0);

            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pneus');
    }
};
