<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('commandes', function (Blueprint $table) {
            $table->foreignId('user_id')->nullable()->change();
            $table->string('name_client')->nullable()->after('user_id');
            $table->string('prenom_client')->nullable()->after('name_client');
            $table->string('telephone_client')->nullable()->after('prenom_client');
            $table->text('adresse_client')->nullable()->after('telephone_client');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('commandes', function (Blueprint $table) {
            $table->foreignId('user_id')->nullable(false)->change();
            $table->dropColumn(['name_client', 'prenom_client', 'telephone_client', 'adresse_client']);
        });
    }
};
