<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            ['name' => 'Pneus', 'slug' => 'pneus', 'icon' => 'bi-record-circle'],
            ['name' => 'Jantes', 'slug' => 'jantes', 'icon' => 'bi-circle-half'],
            ['name' => 'Plaquettes', 'slug' => 'plaquettes', 'icon' => 'bi-layers'],
            ['name' => 'Accessoires', 'slug' => 'accessoires', 'icon' => 'bi-wrench'],
        ];

        foreach ($categories as $category) {
            \App\Models\Category::create($category);
        }
    }
}
