<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Pneu;

class PneuImageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     * Maps pneu names to their corresponding image filenames
     */
    public function run(): void
    {
        // Map pneu model names to image filenames
        $imageMapping = [
            'Primacy 4' => 'Primacy 4.png',
            'CrossClimate 2' => 'CrossClimate 2.png',
            'Energy Saver' => 'Energy Saver.png',
            'Latitude Sport 3' => 'Latitude Sport 3.png',
            'Michelin Agilis 3' => 'Michelin Agilis 3.png',
            'Blizzak LM005' => 'Blizzak LM005.png',
            'UltraGrip 9 plus' => 'UltraGrip 9 plus.png',
            'ContiEcoContact 7' => 'ContiEcoContact 7.png',
            'WinterContact TS870' => 'WinterContact TS870.png',
            'Continental VanContact 4Season' => 'Continental VanContact 4Season.png',
            'VanContact 4Season' => 'VanContact 4Season.png',
            'Scorpion Verde' => 'Scorpion Verde.png',
            'EfficientGrip SUV' => 'EfficientGrip SUV.png',
            'Duravis R660' => 'Duravis R660.png',
        ];

        foreach ($imageMapping as $pneuName => $imageName) {
            // Try to find pneu by exact name match
            $pneu = Pneu::where('nom_pneu', $pneuName)->first();
            
            if ($pneu) {
                $pneu->update(['image' => $imageName]);
                $this->command->info("Updated image for: {$pneuName}");
            } else {
                // Try to find by partial match (LIKE)
                $pneu = Pneu::where('nom_pneu', 'LIKE', "%{$pneuName}%")->first();
                
                if ($pneu) {
                    $pneu->update(['image' => $imageName]);
                    $this->command->info("Updated image for (partial match): {$pneu->nom_pneu} -> {$imageName}");
                } else {
                    $this->command->warn("No pneu found for: {$pneuName}");
                }
            }
        }

        $this->command->info('Pneu image seeding completed!');
    }
}
