@extends('admin.layout')

@section('content')
<h1 class="mb-4">Modifier la Catégorie</h1>

<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card shadow-sm border-0">
            <div class="card-body p-4">
                <form action="{{ route('admin.categories.update', $category->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="mb-4">
                        <label for="name" class="form-label">Nom de la catégorie</label>
                        <input type="text" class="form-control form-control-lg @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $category->name) }}" required>
                        @error('name')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>

                    <div class="mb-4">
                        <label for="icon" class="form-label">Icone Bootstrap</label>
                        <select class="form-select select2-icons @error('icon') is-invalid @enderror" id="icon" name="icon">
                            @php
                                $icons = [
                                    // Transport & Automotive
                                    'bi-car-front', 'bi-car-front-fill', 'bi-ev-front', 'bi-ev-front-fill', 'bi-truck', 'bi-truck-flatbed', 
                                    'bi-bus-front', 'bi-bus-front-fill', 'bi-bicycle', 'bi-scooter', 'bi-airplane', 'bi-airplane-fill',
                                    'bi-fuel-pump', 'bi-fuel-pump-fill', 'bi-ev-station', 'bi-ev-station-fill', 'bi-speedometer', 'bi-speedometer2',
                                    'bi-sign-stop', 'bi-sign-stop-fill', 'bi-sign-turn-left', 'bi-sign-turn-right', 'bi-sign-yield',
                                    'bi-cone', 'bi-cone-striped', 'bi-parking', 'bi-parking-fill',
                                    
                                    // Tools & Settings
                                    'bi-wrench', 'bi-wrench-adjustable', 'bi-tools', 'bi-hammer', 'bi-screwdriver', 'bi-gear', 'bi-gear-fill', 
                                    'bi-gear-wide', 'bi-gear-wide-connected', 'bi-sliders', 'bi-sliders2', 'bi-nut', 'bi-nut-fill',
                                    
                                    // Commerce & Shopping
                                    'bi-bag', 'bi-bag-fill', 'bi-bag-check', 'bi-bag-plus', 'bi-bag-dash', 'bi-bag-x', 'bi-cart', 'bi-cart-fill', 
                                    'bi-cart-check', 'bi-cart-plus', 'bi-cart-dash', 'bi-cart-x', 'bi-shop', 'bi-shop-window', 'bi-basket', 
                                    'bi-basket-fill', 'bi-credit-card', 'bi-credit-card-2-front', 'bi-credit-card-2-back', 'bi-currency-dollar', 
                                    'bi-currency-euro', 'bi-wallet', 'bi-wallet2', 'bi-receipt', 'bi-tag', 'bi-tag-fill', 'bi-tags', 'bi-tags-fill',
                                    
                                    // Objects & UI
                                    'bi-box-seam', 'bi-box', 'bi-boxes', 'bi-archive', 'bi-archive-fill', 'bi-check-circle', 'bi-check-circle-fill',
                                    'bi-check-lg', 'bi-x-circle', 'bi-x-circle-fill', 'bi-x-lg', 'bi-info-circle', 'bi-info-circle-fill',
                                    'bi-exclamation-circle', 'bi-exclamation-circle-fill', 'bi-exclamation-triangle', 'bi-exclamation-triangle-fill',
                                    'bi-question-circle', 'bi-question-circle-fill', 'bi-plus-circle', 'bi-dash-circle', 'bi-search', 
                                    'bi-house', 'bi-house-fill', 'bi-house-door', 'bi-person', 'bi-person-fill', 'bi-person-circle', 
                                    'bi-people', 'bi-people-fill', 'bi-bell', 'bi-bell-fill', 'bi-calendar', 'bi-calendar-check', 'bi-calendar-event',
                                    'bi-clock', 'bi-clock-fill', 'bi-clock-history', 'bi-star', 'bi-star-fill', 'bi-star-half', 'bi-heart', 'bi-heart-fill',
                                    'bi-trash', 'bi-trash-fill', 'bi-pencil', 'bi-pencil-square', 'bi-pencil-fill', 'bi-file-earmark', 'bi-file-text',
                                    'bi-image', 'bi-images', 'bi-camera', 'bi-camera-fill', 'bi-geo-alt', 'bi-geo-alt-fill', 'bi-map', 'bi-map-fill',
                                    'bi-flag', 'bi-flag-fill', 'bi-bookmark', 'bi-bookmark-fill', 'bi-shield', 'bi-shield-check', 'bi-shield-lock',
                                    
                                    // Weather & Nature
                                    'bi-sun', 'bi-sun-fill', 'bi-moon', 'bi-moon-fill', 'bi-cloud', 'bi-cloud-fill', 'bi-cloud-rain', 'bi-cloud-snow',
                                    'bi-snow', 'bi-snow2', 'bi-snow3', 'bi-wind', 'bi-droplet', 'bi-droplet-fill', 'bi-droplet-half', 'bi-lightning', 
                                    'bi-lightning-fill', 'bi-fire', 'bi-tree', 'bi-tree-fill', 'bi-flower1', 'bi-flower2', 'bi-flower3',
                                    
                                    // Shapes & Arrows
                                    'bi-circle', 'bi-circle-fill', 'bi-square', 'bi-square-fill', 'bi-triangle', 'bi-triangle-fill', 
                                    'bi-arrow-right', 'bi-arrow-left', 'bi-arrow-up', 'bi-arrow-down', 'bi-chevron-right', 'bi-chevron-left',
                                    'bi-chevron-up', 'bi-chevron-down', 'bi-caret-right', 'bi-caret-left', 'bi-caret-up', 'bi-caret-down',
                                    
                                    // Devices
                                    'bi-phone', 'bi-phone-fill', 'bi-laptop', 'bi-display', 'bi-hdd', 'bi-hdd-fill', 'bi-cpu', 'bi-cpu-fill',
                                    'bi-battery-full', 'bi-battery-half', 'bi-battery-charging'
                                ];
                            @endphp
                            <option value="">Sélectionner une icône</option>
                            @foreach($icons as $i)
                                <option value="{{ $i }}" data-icon="{{ $i }}" {{ old('icon', $category->icon) == $i ? 'selected' : '' }}>
                                    {{ $i }}
                                </option>
                            @endforeach
                        </select>
                        <div class="form-text">Recherchez et sélectionnez une icône.</div>
                        @error('icon')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>

                    <!-- Suggestion: Scripts should be yielded in a stack, but for specific page logic we can put it here if no stack exists -->
                    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
                    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
                    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
                    <style>
                        .select2-container .select2-selection--single { height: 38px; border: 1px solid #dee2e6; border-radius: 0.375rem; display: flex; align-items: center; }
                        .select2-container--default .select2-selection--single .select2-selection__arrow { height: 36px; }
                        .select2-results__option i { margin-right: 10px; }
                    </style>
                    <script>
                        $(document).ready(function() {
                            function formatState (state) {
                                if (!state.id) { return state.text; }
                                var $state = $('<span><i class="bi ' + state.element.getAttribute('data-icon') + '"></i> ' + state.text + '</span>');
                                return $state;
                            };

                            $('.select2-icons').select2({
                                templateResult: formatState,
                                templateSelection: formatState,
                                width: '100%'
                            });
                        });
                    </script>

                    <div class="d-flex justify-content-between align-items-center mt-5">
                        <a href="{{ route('admin.categories.index') }}" class="btn btn-link text-decoration-none text-muted">Annuler</a>
                        <button type="submit" class="btn btn-primary px-5 rounded-pill shadow-sm">
                            <i class="bi bi-check-lg me-2"></i> Mettre à jour
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
