@extends('admin.layout')

@section('page_title', 'Tableau de bord')

@section('content')
<!-- KPI Cards -->
<div class="row g-4 mb-5">
    @if(Auth::user()->role === 'admin')
    <div class="col-md-3">
        <div class="card border-0 shadow-sm h-100 p-3 bg-white">
            <div class="d-flex align-items-center">
                <div class="icon-shape bg-primary bg-opacity-10 text-primary rounded-4 p-3 me-3">
                    <i class="bi bi-currency-euro fs-4"></i>
                </div>
                <div>
                    <h6 class="text-muted fw-semibold mb-1 small text-uppercase tracking-wider">Chiffre d'affaires</h6>
                    <h3 class="fw-bold mb-0 text-dark">{{ number_format($stats['total_revenue'], 0, '.', ' ') }} <small class="fs-6">MAD</small></h3>
                </div>
            </div>
        </div>
    </div>
    @endif
    <div class="col-md-3">
        <div class="card border-0 shadow-sm h-100 p-3 bg-white">
            <div class="d-flex align-items-center">
                <div class="icon-shape bg-warning bg-opacity-10 text-warning rounded-4 p-3 me-3">
                    <i class="bi bi-clock-history fs-4"></i>
                </div>
                <div>
                    <h6 class="text-muted fw-semibold mb-1 small text-uppercase tracking-wider">En attente</h6>
                    <h3 class="fw-bold mb-0 text-dark">{{ $stats['pending_orders'] }}</h3>
                </div>
            </div>
            <div class="mt-2">
                <span class="text-muted small">Sur {{ $stats['total_orders'] }} commandes au total</span>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-0 shadow-sm h-100 p-3 bg-white">
            <div class="d-flex align-items-center">
                <div class="icon-shape bg-info bg-opacity-10 text-info rounded-4 p-3 me-3">
                    <i class="bi bi-truck fs-4"></i>
                </div>
                <div>
                    <h6 class="text-muted fw-semibold mb-1 small text-uppercase tracking-wider">Commandes en cours</h6>
                    <h3 class="fw-bold mb-0 text-dark">{{ $stats['processing_orders'] }}</h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-0 shadow-sm h-100 p-3 bg-white border-start border-4 border-danger">
            <div class="d-flex align-items-center">
                <div class="icon-shape bg-danger bg-opacity-10 text-danger rounded-4 p-3 me-3">
                    <i class="bi bi-exclamation-triangle fs-4"></i>
                </div>
                <div>
                    <h6 class="text-muted fw-semibold mb-1 small text-uppercase tracking-wider">Stock bas</h6>
                    <h3 class="fw-bold mb-0 text-dark">{{ $stats['low_stock'] }}</h3>
                </div>
            </div>
            <div class="mt-2">
                <a href="#low-stock-table" class="text-danger small fw-bold text-decoration-none">
                    Voir les alertes <i class="bi bi-arrow-right ms-1"></i>
                </a>
            </div>
        </div>
    </div>
</div>

<div class="row g-4">
    <!-- Recent Orders -->
    <div class="col-lg-8">
        <div class="card border-0 shadow-sm rounded-4">
            <div class="card-header bg-transparent border-0 pt-4 px-4 d-flex justify-content-between align-items-center">
                <h5 class="fw-bold mb-0 text-dark">Dernières commandes</h5>
                <a href="{{ route('admin.orders.index') }}" class="btn btn-sm btn-light rounded-pill px-3 fw-semibold">Voir tout</a>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="bg-light">
                            <tr>
                                <th class="ps-4 border-0 text-muted small fw-bold text-uppercase">ID</th>
                                <th class="border-0 text-muted small fw-bold text-uppercase">Client</th>
                                <th class="border-0 text-muted small fw-bold text-uppercase text-end">Montant</th>
                                <th class="border-0 text-muted small fw-bold text-uppercase text-center">Statut</th>
                                <th class="pe-4 border-0 text-muted small fw-bold text-uppercase">Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($recent_orders as $order)
                                <tr>
                                    <td class="ps-4 fw-bold text-muted">#{{ $order->id }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-sm bg-light text-dark rounded-circle me-2 d-flex align-items-center justify-content-center fw-bold small" style="width: 30px; height: 30px;">
                                                {{ substr($order->user ? $order->user->nom : $order->name_client, 0, 1) }}
                                            </div>
                                            <div>
                                                <span class="d-block fw-semibold text-dark">
                                                    @if($order->user)
                                                        {{ $order->user->nom }}
                                                    @else
                                                        {{ $order->name_client }} {{ $order->prenom_client }}
                                                    @endif
                                                </span>
                                                @if(!$order->user_id)
                                                    <span class="badge bg-secondary-subtle text-secondary small" style="font-size: 10px;">CLIENT INVITÉ</span>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td class="text-end fw-bold text-dark">{{ number_format($order->total, 2) }} MAD</td>
                                    <td class="text-center">
                                        @switch($order->statut)
                                            @case('en_attente')
                                                <span class="badge bg-warning bg-opacity-10 text-warning px-3 rounded-pill">En attente</span>
                                                @break
                                            @case('en_cours')
                                                <span class="badge bg-info bg-opacity-10 text-info px-3 rounded-pill">En cours</span>
                                                @break
                                            @case('livres')
                                                <span class="badge bg-success bg-opacity-10 text-success px-3 rounded-pill">Livrée</span>
                                                @break
                                            @case('annulee')
                                                <span class="badge bg-danger bg-opacity-10 text-danger px-3 rounded-pill">Annulée</span>
                                                @break
                                        @endswitch
                                    </td>
                                    <td class="pe-4 text-muted small">{{ $order->created_at->format('d M, Y') }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Stock Alerts -->
    <div class="col-lg-4" id="low-stock-table">
        <div class="card border-0 shadow-sm rounded-4 h-100">
            <div class="card-header bg-transparent border-0 pt-4 px-4">
                <h5 class="fw-bold mb-0 text-dark">Alertes Stock</h5>
            </div>
            <div class="card-body px-4">
                <div class="list-group list-group-flush">
                    @forelse($low_stock_products as $product)
                        <div class="list-group-item px-0 py-3 border-0 border-bottom">
                            <div class="d-flex justify-content-between align-items-start">
                                <div class="me-2">
                                    <h6 class="mb-0 fw-bold text-dark text-truncate" style="max-width: 180px;">{{ $product->name }}</h6>
                                    <span class="text-muted small">{{ $product->marque }} • 
                                        @if($product->category)
                                            {{ $product->category->name }}
                                        @else
                                            Nouveau
                                        @endif
                                    </span>
                                </div>
                                <div class="text-end">
                                    <span class="badge bg-danger rounded-pill px-2">{{ $product->en_stock }} restants</span>
                                    <a href="{{ route('admin.pneus.edit', $product->id) }}" class="d-block mt-2 small text-primary fw-bold text-decoration-none">
                                        Rééditer <i class="bi bi-pencil small"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-5">
                            <i class="bi bi-check-circle-fill text-success display-4 d-block mb-3"></i>
                            <p class="text-muted">Tout est en ordre. Aucun produit en rupture.</p>
                        </div>
                    @endforelse
                </div>
            </div>
            @if(count($low_stock_products) > 0)
            <div class="card-footer bg-transparent border-0 pb-4 px-4">
                <a href="{{ route('admin.pneus.index') }}" class="btn btn-outline-primary btn-sm w-100 rounded-pill fw-bold">Gérer tout le catalogue</a>
            </div>
            @endif
        </div>
    </div>
</div>

<style>
    .tracking-wider { letter-spacing: 0.05em; }
    .icon-shape { width: 56px; height: 56px; display: flex; align-items: center; justify-content: center; }
    .card:hover { transform: translateY(-3px); transition: all 0.3s ease; }
    .table thead th { border-bottom: none !important; }
</style>
@endsection
