@extends('admin.layout')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1>Commande #{{ $commande->id }}</h1>
    <div class="d-flex gap-2">
        <button onclick="window.print()" class="btn btn-primary d-print-none">
            <i class="bi bi-printer me-2"></i>Imprimer la facture
        </button>
        <a href="{{ route('admin.orders.index') }}" class="btn btn-secondary d-print-none">Retour</a>
    </div>
</div>

<div class="invoice-container">
    {{-- Header for Print Only --}}
    <div class="d-none d-print-block mb-5">
        <div class="row align-items-center">
            <div class="col-6">
                <img src="{{ asset('images/logo.png') }}" alt="PNEUS SHOP" style="height: 80px;">
            </div>
            <div class="col-6 text-end">
                <h2 class="text-primary fw-bold">FACTURE</h2>
                <p class="mb-0">N° Commande: <strong>#{{ $commande->id }}</strong></p>
                <p>Date: {{ $commande->created_at->format('d/m/Y') }}</p>
            </div>
        </div>
        <hr class="invoice-divider mt-4 mb-4">
        <div class="row mt-4">
            <div class="col-6">
                <h6 class="text-muted text-uppercase small fw-bold">Émetteur:</h6>
                <p class="mb-0"><strong>{{ $shop->nom_entreprise ?? 'PNEUS SHOP' }}</strong></p>
                <p class="mb-0">{{ $shop->adresse ?? 'Casablanca, Maroc' }}</p>
                <p class="mb-0">Tél: {{ $shop->telephone ?? '+212 5XX XX XX XX' }}</p>
                <p>Email: {{ $shop->email ?? 'contact@pneushop.ma' }}</p>
            </div>
            <div class="col-6 text-end">
                <h6 class="text-muted text-uppercase small fw-bold">Détails de Livraison:</h6>
                @if($commande->user)
                    <p class="mb-0"><strong>{{ $commande->user->nom }} {{ $commande->user->prenom }}</strong></p>
                    <p class="mb-0">{{ $commande->user->adresse }}</p>
                    <p class="mb-0">Tél: {{ $commande->user->telephone }}</p>
                @else
                    <p class="mb-0"><strong>{{ $commande->name_client }} {{ $commande->prenom_client }}</strong></p>
                    <p class="mb-0">{{ $commande->adresse_client }}</p>
                    <p class="mb-0">Tél: {{ $commande->telephone_client }}</p>
                @endif
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card mb-4 d-print-none">
                <div class="card-header">
                    <h5>Informations client</h5>
                </div>
                <div class="card-body">
                    @if($commande->user)
                        <p><strong>Type:</strong> Client inscrit</p>
                        <p><strong>Nom:</strong> {{ $commande->user->nom }} {{ $commande->user->prenom }}</p>
                        <p><strong>Email:</strong> {{ $commande->user->email }}</p>
                        <p><strong>Téléphone:</strong> {{ $commande->user->telephone }}</p>
                        <p><strong>Adresse:</strong> {{ $commande->user->adresse }}</p>
                    @else
                        <p><strong>Type:</strong> Commande express (Invité)</p>
                        <p><strong>Nom:</strong> {{ $commande->name_client }} {{ $commande->prenom_client }}</p>
                        <p><strong>Téléphone:</strong> {{ $commande->telephone_client }}</p>
                        <p><strong>Adresse:</strong> {{ $commande->adresse_client }}</p>
                    @endif
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5 class="d-print-none">Produits commandés</h5>
                    <h5 class="d-none d-print-block">DÉTAILS DES PRODUITS</h5>
                </div>
                <div class="card-body pt-3">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Produit</th>
                                <th class="text-center">Prix unitaire</th>
                                <th class="text-center">Quantité</th>
                                <th class="text-end">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($commande->products as $product)
                                <tr>
                                    <td>
                                        <div class="fw-bold">{{ $product->name }}</div>
                                        <div class="small text-muted">{{ $product->marque }} @if($product->dimension) - {{ $product->dimension }} @endif</div>
                                    </td>
                                    <td class="text-center">{{ number_format($product->pivot->prix_unitaire, 2) }} MAD</td>
                                    <td class="text-center text-primary fw-bold">{{ $product->pivot->quantite }}</td>
                                    <td class="text-end fw-bold">{{ number_format($product->pivot->prix_unitaire * $product->pivot->quantite, 2) }} MAD</td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="3" class="text-end py-3">GRAND TOTAL:</th>
                                <th class="text-end text-primary h4 fw-bold py-3">{{ number_format($commande->total, 2) }} MAD</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            {{-- Footer for Print Only --}}
            <div class="d-none d-print-block mt-5 text-center">
                <p class="text-muted small">Merci pour votre confiance !</p>
            </div>
        </div>

        <div class="col-md-4 d-print-none">
            <div class="card">
                <div class="card-header">
                    <h5>Détails de la commande</h5>
                </div>
                <div class="card-body">
                    <p><strong>Date:</strong> {{ $commande->created_at->format('d/m/Y H:i') }}</p>
                    <p><strong>Statut actuel:</strong> 
                        @switch($commande->statut)
                            @case('en_attente')
                                <span class="badge bg-warning">En attente</span>
                                @break
                            @case('en_cours')
                                <span class="badge bg-info">En cours</span>
                                @break
                            @case('livres')
                                <span class="badge bg-success">Livrée</span>
                                @break
                            @case('annulee')
                                <span class="badge bg-danger">Annulée</span>
                                @break
                        @endswitch
                    </p>
                    
                    <hr>
                    
                    <h6>Modifier le statut</h6>
                    <form action="{{ route('admin.orders.updateStatus', $commande->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="mb-3">
                            <select name="statut" class="form-select">
                                <option value="en_attente" {{ $commande->statut == 'en_attente' ? 'selected' : '' }}>En attente</option>
                                <option value="en_cours" {{ $commande->statut == 'en_cours' ? 'selected' : '' }}>En cours</option>
                                <option value="livres" {{ $commande->statut == 'livres' ? 'selected' : '' }}>Livrée</option>
                                <option value="annulee" {{ $commande->statut == 'annulee' ? 'selected' : '' }}>Annulée</option>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Mettre à jour</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
