@extends('admin.layout')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 fw-bold text-dark mb-1">Ajouter un produit</h1>
        <p class="text-muted small mb-0">Remplissez les informations ci-dessous pour ajouter un nouvel article au catalogue</p>
    </div>
    <a href="{{ route('admin.pneus.index') }}" class="btn btn-outline-secondary rounded-pill px-4">
        <i class="bi bi-arrow-left me-2"></i> Retour
    </a>
</div>

<div class="card border-0 shadow-sm rounded-4 overflow-hidden">
    <div class="card-body p-4 p-md-5">
        <form action="{{ route('admin.pneus.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            
            <!-- Product Type Selector -->
            <div class="mb-5 p-4 bg-light rounded-4 border">
                <h5 class="fw-bold mb-3"><i class="bi bi-tag-fill text-primary me-2"></i> Quel type de produit ajoutez-vous ?</h5>
                <div class="row g-3">
                    <div class="col-md-6">
                        <input type="radio" class="btn-check" name="product_type" id="type_pneu_radio" value="pneu" checked>
                        <label class="btn btn-outline-primary w-100 py-3 rounded-3 d-flex flex-column align-items-center" for="type_pneu_radio">
                            <i class="bi bi-tire fs-2 mb-2"></i>
                            <span class="fw-bold">Pneu</span>
                            <small class="opacity-75">Toutes caractéristiques techniques</small>
                        </label>
                    </div>
                    <div class="col-md-6">
                        <input type="radio" class="btn-check" name="product_type" id="type_general_radio" value="general">
                        <label class="btn btn-outline-secondary w-100 py-3 rounded-3 d-flex flex-column align-items-center" for="type_general_radio">
                            <i class="bi bi-box-seam fs-2 mb-2"></i>
                            <span class="fw-bold">Produit Général</span>
                            <small class="opacity-75">Jantes, Plaquettes, Accessoires...</small>
                        </label>
                    </div>
                </div>
            </div>

            <div class="row g-4">
                <!-- COMMON INFO -->
                <div class="col-md-12">
                    <h5 class="fw-bold mb-3 border-bottom pb-2">Informations de base</h5>
                </div>
                
                <div class="col-md-6">
                    <label for="name" class="form-label fw-semibold">Nom du produit *</label>
                    <input type="text" class="form-control @error('name') is-invalid @enderror shadow-sm" id="name" name="name" value="{{ old('name') }}" required>
                </div>

                <div class="col-md-6">
                    <label for="marque" class="form-label fw-semibold">Marque *</label>
                    <input type="text" class="form-control @error('marque') is-invalid @enderror shadow-sm" id="marque" name="marque" value="{{ old('marque') }}" required>
                </div>

                <div class="col-md-4">
                    <label for="category_id" class="form-label fw-semibold">Catégorie *</label>
                    <select class="form-select @error('category_id') is-invalid @enderror shadow-sm" id="category_id" name="category_id" required>
                        <option value="">Choisir une catégorie...</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" data-slug="{{ $category->slug }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-4">
                    <label for="prix_actuel" class="form-label fw-semibold">Prix de vente (MAD) *</label>
                    <input type="number" step="0.01" class="form-control shadow-sm" id="prix_actuel" name="prix_actuel" value="{{ old('prix_actuel') }}" required>
                </div>

                <div class="col-md-4">
                    <label for="en_stock" class="form-label fw-semibold">Quantité en stock *</label>
                    <input type="number" class="form-control shadow-sm" id="en_stock" name="en_stock" value="{{ old('en_stock', 1) }}" required>
                </div>

                <!-- TIRE SPECIFIC FIELDS -->
                <div id="pneu_fields_section" class="col-md-12">
                    <div class="row g-4 mt-2">
                        <div class="col-md-12">
                            <h5 class="fw-bold mb-3 border-bottom pb-2">Caractéristiques Techniques Pneu</h5>
                        </div>

                        <div class="col-md-3">
                            <label for="type_pneu" class="form-label fw-semibold text-primary">Type de véhicule</label>
                            <select class="form-select border-primary shadow-sm" id="type_pneu" name="type_pneu">
                                <option value="">Choisir...</option>
                                <option value="Tourisme">Tourisme</option>
                                <option value="4x4 / SUV">4x4 / SUV</option>
                                <option value="Camionnette / Utilitaire">Camionnette / Utilitaire</option>
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label for="saison" class="form-label fw-semibold text-primary">Saison</label>
                            <select class="form-select border-primary shadow-sm" id="saison" name="saison">
                                <option value="">Choisir...</option>
                                <option value="Été">Été</option>
                                <option value="Hiver">Hiver</option>
                                <option value="4 Saisons">4 Saisons</option>   
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label for="dimension" class="form-label fw-semibold text-primary">Dimension</label>
                            <input type="text" class="form-control border-primary shadow-sm" id="dimension" name="dimension" placeholder="Ex: 205/55R16">
                        </div>

                        <div class="col-md-3">
                            <label for="dot_annee" class="form-label fw-semibold text-primary">DOT (Année)</label>
                            <input type="number" class="form-control border-primary shadow-sm" id="dot_annee" name="dot_annee" value="{{ date('Y') }}">
                        </div>

                        <div class="col-md-3">
                            <label for="largeur" class="form-label fw-semibold">Largeur</label>
                            <input type="number" class="form-control" id="largeur" name="largeur" placeholder="Ex: 205">
                        </div>

                        <div class="col-md-3">
                            <label for="hauteur" class="form-label fw-semibold">Hauteur (%)</label>
                            <input type="number" class="form-control" id="hauteur" name="hauteur" placeholder="Ex: 55">
                        </div>

                        <div class="col-md-3">
                            <label for="diametre" class="form-label fw-semibold">Diamètre</label>
                            <input type="text" class="form-control" id="diametre" name="diametre" placeholder="Ex: R16">
                        </div>
                        
                        <div class="col-md-3">
                            <label for="pays_fabrication" class="form-label fw-semibold">Origine</label>
                            <input type="text" class="form-control" id="pays_fabrication" name="pays_fabrication" placeholder="Ex: France">
                        </div>

                        <div class="col-md-3">
                            <label for="charge_index" class="form-label fw-semibold">Indice Charge</label>
                            <input type="number" class="form-control" id="charge_index" name="charge_index" placeholder="Ex: 91">
                        </div>

                        <div class="col-md-3">
                            <label for="vitesse_index" class="form-label fw-semibold">Indice Vitesse</label>
                            <select class="form-select" id="vitesse_index" name="vitesse_index">
                                <option value="">Choisir...</option>
                                @foreach(['L','M','N','P','Q','R','S','T','U','H','V','W','Y','(Y)','ZR'] as $v)
                                    <option value="{{$v}}">{{$v}}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-3">
                            <label for="vitesse_kmh" class="form-label fw-semibold">Vitesse Max (km/h)</label>
                            <input type="text" class="form-control" id="vitesse_kmh" name="vitesse_kmh" placeholder="Ex: 210 km/h">
                        </div>

                        <div class="col-md-3">
                            <label for="bruit_externe_db" class="form-label fw-semibold">Bruit (dB)</label>
                            <input type="number" class="form-control" id="bruit_externe_db" name="bruit_externe_db" placeholder="Ex: 71">
                        </div>

                        <div class="col-md-4">
                            <label for="conso_carburant" class="form-label fw-semibold">Consommation</label>
                            <select class="form-select" id="conso_carburant" name="conso_carburant">
                                <option value="">Classe...</option>
                                @foreach(['A','B','C','D','E'] as $c) <option value="{{$c}}">{{$c}}</option> @endforeach
                            </select>
                        </div>

                        <div class="col-md-4">
                            <label for="adherence_sol_mouille" class="form-label fw-semibold">Adhérence sol mouillé</label>
                            <select class="form-select" id="adherence_sol_mouille" name="adherence_sol_mouille">
                                <option value="">Classe...</option>
                                @foreach(['A','B','C','D','E'] as $c) <option value="{{$c}}">{{$c}}</option> @endforeach
                            </select>
                        </div>

                        <div class="col-md-4 d-flex align-items-end gap-3">
                            <div class="form-check form-switch mb-2">
                                <input class="form-check-input" type="checkbox" id="runflat" name="runflat">
                                <label class="form-check-label fw-bold" for="runflat">RunFlat</label>
                            </div>
                            <div class="form-check form-switch mb-2">
                                <input class="form-check-input" type="checkbox" id="renforce" name="renforce">
                                <label class="form-check-label fw-bold" for="renforce">Renforcé</label>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- GENERAL FIELDS -->
                <div class="col-md-6">
                    <h5 class="fw-bold mb-3 border-bottom pb-2">Informations complémentaires</h5>
                    <div class="mb-3">
                        <label for="sku" class="form-label fw-semibold">Référence (SKU)</label>
                        <input type="text" class="form-control shadow-sm" id="sku" name="sku">
                    </div>
                    <div class="mb-3">
                        <label for="pays_fabrication_generale" class="form-label fw-semibold">Origine</label>
                        <input type="text" class="form-control shadow-sm" id="pays_fabrication_generale" name="pays_fabrication" placeholder="Ex: France" value="{{ old('pays_fabrication') }}">
                    </div>
                    <div class="mb-3">
                        <label for="prix_ancien" class="form-label fw-semibold">Prix barré (Optionnel)</label>
                        <input type="number" step="0.01" class="form-control shadow-sm" id="prix_ancien" name="prix_ancien">
                    </div>
                </div>

                <div class="col-md-6">
                    <h5 class="fw-bold mb-3 border-bottom pb-2">Visuel & Description</h5>
                    <div class="mb-3">
                        <label for="image" class="form-label fw-semibold">Image du produit</label>
                        <input type="file" class="form-control shadow-sm" id="image" name="image" accept="image/*">
                    </div>
                    <div>
                        <label for="description" class="form-label fw-semibold">Description</label>
                        <textarea class="form-control shadow-sm" id="description" name="description" rows="4"></textarea>
                    </div>
                </div>
            </div>

            <div class="mt-5 pt-3 border-top d-flex gap-3">
                <button type="submit" class="btn btn-primary px-5 py-2 rounded-pill shadow">
                    <i class="bi bi-check-circle me-2"></i> Enregistrer le produit
                </button>
                <button type="reset" class="btn btn-light px-4 rounded-pill">Réinitialiser</button>
            </div>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const radioPneu = document.getElementById('type_pneu_radio');
    const radioGeneral = document.getElementById('type_general_radio');
    const pneuSection = document.getElementById('pneu_fields_section');
    const categorySelect = document.getElementById('category_id');

    function toggleFields() {
        if (radioPneu.checked) {
            pneuSection.style.display = 'block';
            // Auto-select "Pneus" category if it exists
            Array.from(categorySelect.options).forEach(option => {
                if (option.getAttribute('data-slug') === 'pneus') {
                    categorySelect.value = option.value;
                }
            });
        } else {
            pneuSection.style.display = 'none';
        }
    }

    radioPneu.addEventListener('change', toggleFields);
    radioGeneral.addEventListener('change', toggleFields);

    // Also toggle based on category select
    categorySelect.addEventListener('change', function() {
        const slug = this.options[this.selectedIndex].getAttribute('data-slug');
        if (slug === 'pneus') {
            radioPneu.checked = true;
        } else {
            radioGeneral.checked = true;
        }
        toggleFields();
    });

    toggleFields();
});
</script>
@endsection
