@extends('admin.layout')

@section('page_title', 'Gestion du Catalogue')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h3 class="fw-bold text-dark mb-1">Produits</h3>
        <p class="text-muted small mb-0">Gérez l'ensemble de votre inventaire (Pneus, Jantes, Plaquettes)</p>
    </div>
    <a href="{{ route('admin.pneus.create') }}" class="btn btn-primary shadow-sm">
        <i class="bi bi-plus-lg me-2"></i> Ajouter un produit
    </a>
</div>

<div class="card border-0 shadow-sm rounded-4 overflow-hidden">
    <div class="card-header bg-white border-0 py-3 px-4 mt-2">
        <form action="{{ route('admin.pneus.index') }}" method="GET" class="row align-items-center g-3">
            <div class="col-md-4">
                <div class="input-group input-group-sm bg-light rounded-pill px-3 py-1">
                    <span class="input-group-text bg-transparent border-0"><i class="bi bi-search text-muted"></i></span>
                    <input type="text" name="search" class="form-control bg-transparent border-0" placeholder="Rechercher (Nom, Marque, SKU)..." value="{{ request('search') }}">
                </div>
            </div>
            <div class="col-md-3">
                <select name="category_id" class="form-select form-select-sm bg-light border-0 rounded-pill px-3" onchange="this.form.submit()">
                    <option value="">Toutes les catégories</option>
                    @foreach($categories as $category)
                        <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>
                            {{ $category->name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-5 text-md-end mt-3 mt-md-0">
                <div class="d-flex justify-content-md-end gap-2">
                    <button type="submit" class="btn btn-sm btn-dark rounded-pill px-3">
                        <i class="bi bi-filter me-1"></i> Appliquer
                    </button>
                    <a href="{{ route('admin.pneus.index') }}" class="btn btn-sm btn-outline-secondary rounded-pill px-3">
                        <i class="bi bi-arrow-counterclockwise me-1"></i> Réinitialiser
                    </a>
                </div>
            </div>
        </form>
    </div>
    
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light border-bottom">
                    <tr>
                        <th class="ps-4 py-3 text-muted small fw-bold text-uppercase border-0">Aperçu</th>
                        <th class="py-3 text-muted small fw-bold text-uppercase border-0">Détails Produit</th>
                        <th class="py-3 text-muted small fw-bold text-uppercase border-0 text-center">Catégorie</th>
                        <th class="py-3 text-muted small fw-bold text-uppercase border-0">Marque</th>
                        <th class="py-3 text-muted small fw-bold text-uppercase border-0 text-end">Prix</th>
                        <th class="py-3 text-muted small fw-bold text-uppercase border-0 text-center">Stock</th>
                        <th class="pe-4 py-3 text-muted small fw-bold text-uppercase border-0 text-end">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($products as $product)
                        <tr>
                            <td class="ps-4">
                                <div class="product-img-container bg-light rounded-3 d-flex align-items-center justify-content-center overflow-hidden" style="width: 50px; height: 50px;">
                                    @if($product->image)
                                        <img src="{{ asset('storage/pneus/' . $product->image) }}" alt="{{ $product->name }}" style="width: 100%; height: 100%; object-fit: contain;">
                                    @else
                                        <i class="bi bi-image text-muted fs-4"></i>
                                    @endif
                                </div>
                            </td>
                            <td>
                                <div class="fw-bold text-dark">{{ $product->name }}</div>
                                <div class="text-muted small">ID: #{{ $product->id }} • {{ $product->sku ?? 'PAS DE SKU' }}</div>
                            </td>
                            <td class="text-center">
                                @if($product->category)
                                    <span class="badge bg-primary bg-opacity-10 text-primary px-3 rounded-pill fw-medium">
                                        {{ $product->category->name }}
                                    </span>
                                @else
                                    <span class="text-muted small">Non classé</span>
                                @endif
                            </td>
                            <td>
                                <span class="fw-medium">{{ $product->marque }}</span>
                            </td>
                            <td class="text-end">
                                <div class="fw-bold text-dark">{{ number_format($product->prix_actuel, 2) }} MAD</div>
                                @if($product->prix_ancien)
                                    <div class="text-muted small text-decoration-line-through">{{ number_format($product->prix_ancien, 2) }}</div>
                                @endif
                            </td>
                            <td class="text-center">
                                @if($product->en_stock <= 0)
                                    <span class="badge bg-danger bg-opacity-10 text-danger px-3 rounded-pill">Rupture</span>
                                @elseif($product->en_stock < 5)
                                    <span class="badge bg-warning bg-opacity-10 text-warning px-3 rounded-pill">Critique ({{ $product->en_stock }})</span>
                                @else
                                    <span class="badge bg-success bg-opacity-10 text-success px-3 rounded-pill">{{ $product->en_stock }}</span>
                                @endif
                            </td>
                            <td class="pe-4 text-end">
                                <div class="d-flex justify-content-end gap-2">
                                    <a href="{{ route('admin.pneus.edit', $product->id) }}" class="btn btn-icon btn-light-primary rounded-circle" title="Modifier">
                                        <i class="bi bi-pencil-square"></i>
                                    </a>
                                    <form action="{{ route('admin.pneus.destroy', $product->id) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-icon btn-light-danger rounded-circle" onclick="return confirm('Supprimer ce produit définitivement ?')" title="Supprimer">
                                            <i class="bi bi-trash3"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        <div class="card-footer bg-white border-0 py-4 px-4 border-top">
            <div class="d-flex flex-column flex-md-row justify-content-between align-items-center gap-3">
                <div class="text-muted small">
                    Affichage de <b>{{ $products->firstItem() }}</b> à <b>{{ $products->lastItem() }}</b> sur <b>{{ $products->total() }}</b> produits
                </div>
                <div>
                    {{ $products->links() }}
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .pagination-container nav p, .card-footer nav p {
        display: none !important;
    }
    .product-img-container {
        border: 1px solid #f1f5f9;
        transition: transform 0.2s ease;
    }
    .product-img-container:hover {
        transform: scale(1.1);
    }
    .btn-icon {
        width: 32px;
        height: 32px;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 0;
        transition: all 0.2s ease;
    }
    .btn-light-primary {
        background-color: #e0e7ff;
        color: #4338ca;
        border: none;
    }
    .btn-light-primary:hover {
        background-color: #4338ca;
        color: white;
    }
    .btn-light-danger {
        background-color: #fee2e2;
        color: #dc2626;
        border: none;
    }
    .btn-light-danger:hover {
        background-color: #dc2626;
        color: white;
    }
    .table-hover tbody tr:hover {
        background-color: #f8fafc;
    }
    .pagination {
        margin-bottom: 0;
    }
    .page-link {
        border-radius: 8px !important;
        margin: 0 2px;
        border: none;
        color: #64748b;
        background-color: #f1f5f9;
    }
    .page-item.active .page-link {
        background-color: var(--primary-color);
        box-shadow: 0 4px 10px rgba(13, 110, 253, 0.2);
    }
</style>
@endsection
