@extends('admin.layout')

@section('page_title', 'Mon Profil Admin')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card shadow-sm border-0">
            <div class="card-body p-5">
                <form action="{{ route('admin.profile.update') }}" method="POST">
                    @csrf
                    @method('PUT')

                    <h5 class="fw-bold mb-4 text-primary"><i class="bi bi-person-lines-fill me-2"></i> Informations Personnelles</h5>
                    
                    <div class="row g-3 mb-4">
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="text" name="prenom" class="form-control border-0 bg-light rounded-3 @error('prenom') is-invalid @enderror" id="prenom" value="{{ old('prenom', $user->prenom) }}" placeholder="Prénom" required>
                                <label for="prenom">Prénom</label>
                                @error('prenom')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="text" name="nom" class="form-control border-0 bg-light rounded-3 @error('nom') is-invalid @enderror" id="nom" value="{{ old('nom', $user->nom) }}" placeholder="Nom" required>
                                <label for="nom">Nom</label>
                                @error('nom')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                        </div>
                    </div>

                    <div class="row g-3 mb-4">
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="email" name="email" class="form-control border-0 bg-light rounded-3 @error('email') is-invalid @enderror" id="email" value="{{ old('email', $user->email) }}" placeholder="Email" required pattern="[a-z0-9._%+-]+@gmail\.com$" title="L'adresse email doit se terminer par @gmail.com">
                                <label for="email">Email</label>
                                @error('email')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="text" name="telephone" class="form-control border-0 bg-light rounded-3 @error('telephone') is-invalid @enderror" id="telephone" value="{{ old('telephone', $user->telephone) }}" placeholder="Téléphone" required maxlength="10" minlength="10" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10)" title="Le numéro doit contenir exactement 10 chiffres">
                                <label for="telephone">Téléphone</label>
                                @error('telephone')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-floating mb-5">
                        <textarea name="adresse" class="form-control border-0 bg-light rounded-3 @error('adresse') is-invalid @enderror" id="adresse" placeholder="Adresse" style="height: 100px" required>{{ old('adresse', $user->adresse) }}</textarea>
                        <label for="adresse">Adresse complète</label>
                        @error('adresse')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>

                    <hr class="my-5 opacity-10">

                    <h5 class="fw-bold mb-4 text-primary"><i class="bi bi-building me-2"></i> Informations Entreprise</h5>
                    <div class="row g-3 mb-5">
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="text" name="nom_entreprise" class="form-control border-0 bg-light rounded-3" id="entreprise" value="{{ old('nom_entreprise', $user->nom_entreprise) }}" placeholder="Nom Entreprise">
                                <label for="entreprise">Nom de l'entreprise</label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="text" name="ice" class="form-control border-0 bg-light rounded-3" id="ice" value="{{ old('ice', $user->ice) }}" placeholder="ICE">
                                <label for="ice">ICE</label>
                            </div>
                        </div>
                    </div>

                    <hr class="my-5 opacity-10">

                    <h5 class="fw-bold mb-4 text-warning"><i class="bi bi-shield-lock me-2"></i> Sécurité</h5>
                    
                    <div class="form-floating mb-3">
                        <input type="password" name="current_password" class="form-control border-0 bg-light rounded-3 @error('current_password') is-invalid @enderror" id="current_password" placeholder="Mot de passe actuel">
                        <label for="current_password">Mot de passe actuel</label>
                        @error('current_password')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>

                    <div class="row g-3 mb-4">
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="password" name="new_password" class="form-control border-0 bg-light rounded-3 @error('new_password') is-invalid @enderror" id="new_password" placeholder="Nouveau mot de passe">
                                <label for="new_password">Nouveau mot de passe</label>
                                @error('new_password')<div class="invalid-feedback">{{ $message }}</div>@enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="password" name="new_password_confirmation" class="form-control border-0 bg-light rounded-3" id="new_password_confirmation" placeholder="Confirmer">
                                <label for="new_password_confirmation">Confirmer le nouveau mot de passe</label>
                            </div>
                        </div>
                    </div>

                    <div class="text-end">
                        <button type="submit" class="btn btn-primary btn-lg rounded-pill px-5 shadow-sm">
                            <i class="bi bi-save me-2"></i> Enregistrer les modifications
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
