@extends('admin.layout')

@section('content')
<h1 class="mb-4">Modifier l'utilisateur</h1>

<div class="card">
    <div class="card-body">
        <form action="{{ route('admin.users.update', $user->id) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="nom" class="form-label">Nom *</label>
                    <input type="text" class="form-control @error('nom') is-invalid @enderror" 
                           id="nom" name="nom" value="{{ old('nom', $user->nom) }}" required>
                    @error('nom')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="prenom" class="form-label">Prénom *</label>
                    <input type="text" class="form-control @error('prenom') is-invalid @enderror" 
                           id="prenom" name="prenom" value="{{ old('prenom', $user->prenom) }}" required>
                    @error('prenom')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="email" class="form-label">Email *</label>
                    <input type="email" class="form-control @error('email') is-invalid @enderror" 
                           id="email" name="email" value="{{ old('email', $user->email) }}" required pattern="[a-z0-9._%+-]+@gmail\.com$" title="L'adresse email doit se terminer par @gmail.com">
                    @error('email')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="telephone" class="form-label">Téléphone *</label>
                    <input type="text" class="form-control @error('telephone') is-invalid @enderror" 
                           id="telephone" name="telephone" value="{{ old('telephone', $user->telephone) }}" required maxlength="10" minlength="10" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10)" title="Le numéro doit contenir exactement 10 chiffres">
                    @error('telephone')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>
            
            <div class="mb-3">
                <label for="adresse" class="form-label">Adresse *</label>
                <textarea class="form-control @error('adresse') is-invalid @enderror" 
                          id="adresse" name="adresse" rows="3" required>{{ old('adresse', $user->adresse) }}</textarea>
                @error('adresse')<div class="invalid-feedback">{{ $message }}</div>@enderror
            </div>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="nom_entreprise" class="form-label">Nom de l'entreprise</label>
                    <input type="text" class="form-control @error('nom_entreprise') is-invalid @enderror" 
                           id="nom_entreprise" name="nom_entreprise" value="{{ old('nom_entreprise', $user->nom_entreprise) }}">
                    @error('nom_entreprise')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
                <div class="col-md-6 mb-3">
                    <label for="ice" class="form-label">ICE</label>
                    <input type="text" class="form-control @error('ice') is-invalid @enderror" 
                           id="ice" name="ice" value="{{ old('ice', $user->ice) }}">
                    @error('ice')<div class="invalid-feedback">{{ $message }}</div>@enderror
                </div>
            </div>

            <div class="mb-3">
                <label for="role" class="form-label">Rôle *</label>
                <select class="form-select @error('role') is-invalid @enderror" id="role" name="role" required>
                    <option value="client" {{ $user->role == 'client' ? 'selected' : '' }}>Client</option>
                    <option value="staff" {{ $user->role == 'staff' ? 'selected' : '' }}>Staff</option>
                    <option value="admin" {{ $user->role == 'admin' ? 'selected' : '' }}>Admin</option>
                </select>
                @error('role')<div class="invalid-feedback">{{ $message }}</div>@enderror
            </div>

            <div class="p-3 bg-light rounded-3 mb-4 border">
                <h6 class="fw-bold mb-3 d-flex align-items-center">
                    <i class="bi bi-shield-lock me-2 text-warning"></i> Gestion du Mot de Passe
                </h6>
                <div class="row">
                    <div class="col-md-6">
                        <label for="password" class="form-label">Nouveau mot de passe</label>
                        <input type="password" class="form-control @error('password') is-invalid @enderror" 
                               id="password" name="password" placeholder="Laissez vide pour conserver l'actuel">
                        @error('password')<div class="invalid-feedback">{{ $message }}</div>@enderror
                    </div>
                    <div class="col-md-6">
                        <label for="password_confirmation" class="form-label">Confirmer le mot de passe</label>
                        <input type="password" class="form-control" 
                               id="password_confirmation" name="password_confirmation" placeholder="Confirmez le nouveau mot de passe">
                    </div>
                </div>
            </div>
            
            <div class="d-flex justify-content-between">
                <a href="{{ route('admin.users.index') }}" class="btn btn-secondary px-4">Annuler</a>
                <button type="submit" class="btn btn-primary px-4 shadow-sm">
                    <i class="bi bi-check-lg"></i> Mettre à jour l'utilisateur
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
