@extends('admin.layout')

@section('content')
<h1 class="mb-4">Gestion des Utilisateurs</h1>

<div class="card">
    <div class="card-header bg-white border-bottom py-3">
        <form action="{{ route('admin.users.index') }}" method="GET" class="row align-items-center g-3">
            <div class="col-md-8">
                <h5 class="mb-0 fw-bold">Liste des utilisateurs ({{ $users->total() }})</h5>
            </div>
            <div class="col-md-4 text-md-end">
                <div class="d-flex justify-content-md-end gap-2 align-items-center">
                    <select name="role" class="form-select form-select-sm" onchange="this.form.submit()" style="max-width: 200px;">
                        <option value="">Tous les rôles</option>
                        <option value="admin" {{ request('role') == 'admin' ? 'selected' : '' }}>Admin</option>
                        <option value="staff" {{ request('role') == 'staff' ? 'selected' : '' }}>Staff</option>
                        <option value="client" {{ request('role') == 'client' ? 'selected' : '' }}>Client</option>
                    </select>
                    @if(request('role'))
                        <a href="{{ route('admin.users.index') }}" class="btn btn-sm btn-outline-secondary">Reset</a>
                    @endif
                </div>
            </div>
        </form>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>Client / Utilisateur</th>
                        <th>Statut</th>
                        <th>Contact</th>
                        <th>Info Entreprise</th>
                        <th>Rôle</th>
                        <th>Inscrit le</th>
                        <th class="text-end">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($users as $user)
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="avatar-sm me-3 bg-light text-primary rounded-circle d-flex align-items-center justify-content-center fw-bold" style="width: 40px; height: 40px;">
                                    {{ substr($user->nom, 0, 1) }}
                                </div>
                                <div>
                                    <div class="fw-bold text-dark">{{ $user->nom }} {{ $user->prenom }}</div>
                                    <div class="small text-muted text-truncate" style="max-width: 150px;">{{ $user->adresse }}</div>
                                </div>
                            </div>
                        </td>
                        <td>
                            @if($user->is_connected)
                                <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25 rounded-pill">
                                    <i class="bi bi-circle-fill me-1 small"></i> En ligne
                                </span>
                            @else
                                <span class="badge bg-secondary bg-opacity-10 text-secondary border border-secondary border-opacity-25 rounded-pill">
                                    <i class="bi bi-circle-fill me-1 small"></i> Hors ligne
                                </span>
                            @endif
                        </td>
                        <td>
                            <div class="d-flex flex-column">
                                <a href="mailto:{{ $user->email }}" class="text-decoration-none text-muted small mb-1">
                                    <i class="bi bi-envelope me-1"></i> {{ $user->email }}
                                </a>
                                <a href="tel:{{ $user->telephone }}" class="text-decoration-none text-dark fw-medium small">
                                    <i class="bi bi-telephone me-1"></i> {{ $user->telephone }}
                                </a>
                            </div>
                        </td>
                        <td>
                            @if($user->nom_entreprise)
                                <div class="fw-bold text-dark small">{{ $user->nom_entreprise }}</div>
                                <div class="text-muted x-small">ICE: {{ $user->ice ?? 'N/A' }}</div>
                            @else
                                <span class="badge bg-light text-muted border fw-normal">Particulier</span>
                            @endif
                        </td>
                        <td>
                            @switch($user->role)
                                @case('admin')
                                    <span class="badge bg-danger bg-opacity-10 text-danger border border-danger border-opacity-25 rounded-pill">Admin</span>
                                    @break
                                @case('staff')
                                    <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25 rounded-pill">Staff</span>
                                    @break
                                @case('client')
                                    <span class="badge bg-primary bg-opacity-10 text-primary border border-primary border-opacity-25 rounded-pill">Client</span>
                                    @break
                            @endswitch
                        </td>
                        <td class="small text-muted">{{ $user->created_at->format('d/m/Y') }}</td>
                        <td class="text-end">
                            <a href="{{ route('admin.users.edit', $user->id) }}" class="btn btn-sm btn-outline-primary me-1" title="Modifier">
                                <i class="bi bi-pencil"></i>
                            </a>
                            @if($user->id !== auth()->id())
                                <form action="{{ route('admin.users.toggleBlock', $user->id) }}" method="POST" class="d-inline me-1">
                                    @csrf
                                    @method('PUT')
                                    <button type="submit" class="btn btn-sm {{ $user->is_blocked ? 'btn-success' : 'btn-outline-dark' }}" title="{{ $user->is_blocked ? 'Débloquer' : 'Bloquer' }}">
                                        <i class="bi {{ $user->is_blocked ? 'bi-check-circle' : 'bi-slash-circle' }}"></i>
                                    </button>
                                </form>

                                <form action="{{ route('admin.users.destroy', $user->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer cet utilisateur ?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Supprimer">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="6" class="text-center py-5 text-muted">Aucun utilisateur trouvé.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        <div class="d-flex justify-content-center mt-4">
            {{ $users->links() }}
        </div>
    </div>
</div>
@endsection
