@extends('layouts.app')

@section('content')
<div class="container py-5">
    <div class="mb-5">
        <h1 class="fw-black text-dark mb-1">Votre Panier</h1>
        <p class="text-muted">Gérez vos articles et finalisez votre commande en toute sécurité.</p>
    </div>


    @if(empty($cart))
        <div class="card border-0 shadow-sm rounded-4 py-5 text-center">
            <div class="card-body py-5">
                <div class="mb-4">
                    <i class="bi bi-cart-x text-muted display-1 opacity-25"></i>
                </div>
                <h3 class="fw-bold text-dark">Votre panier est vide</h3>
                <p class="text-muted mb-4">Il semble que vous n'ayez pas encore ajouté de produits.</p>
                <a href="{{ route('products.index') }}" class="btn btn-primary rounded-pill px-5 shadow-sm">
                    Parcourir la boutique
                </a>
            </div>
        </div>
    @else
        <div class="row g-4">
            <!-- Cart Items Column -->
            <div class="col-lg-8">
                <div class="card border-0 shadow-sm rounded-4 overflow-hidden mb-4">
                    <div class="card-header bg-white py-3 border-0">
                        <h5 class="fw-bold text-dark mb-0">Articles dans le panier ({{ count($cart) }})</h5>
                    </div>
                    <div class="table-responsive">
                        <table class="table align-middle mb-0">
                            <thead class="bg-light text-uppercase small text-muted">
                                <tr>
                                    <th class="ps-4 border-0">Produit</th>
                                    <th class="border-0 text-center">Quantité</th>
                                    <th class="border-0 text-end">Total</th>
                                    <th class="pe-4 border-0 text-end">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($cart as $id => $item)
                                    <tr>
                                        <td class="ps-4 py-4">
                                            <div class="d-flex align-items-center">
                                                @if(isset($item['image']) && $item['image'] && Storage::disk('public')->exists('pneus/' . $item['image']))
                                                    <img src="{{ asset('storage/pneus/' . $item['image']) }}" class="rounded-3 me-3 bg-light p-1" width="60" height="60" style="object-fit: contain;">
                                                @else
                                                    <div class="bg-light rounded-3 d-flex align-items-center justify-content-center me-3" width="60" height="60">
                                                        <i class="bi bi-image text-muted fs-4"></i>
                                                    </div>
                                                @endif
                                                <div>
                                                    <div class="fw-bold text-dark h6 mb-1">{{ $item['nom'] }}</div>
                                                    <div class="small text-muted mb-1">{{ $item['marque'] }} @if(isset($item['dimension'])) - {{ $item['dimension'] }} @endif</div>
                                                    <div class="fw-bold text-primary small">{{ number_format($item['prix'], 2) }} MAD</div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="py-4 text-center">
                                            <form action="{{ route('cart.update', $id) }}" method="POST" class="d-inline-flex align-items-center justify-content-center">
                                                @csrf
                                                @method('PUT')
                                                <div class="input-group input-group-sm shadow-sm rounded-pill overflow-hidden" style="width: 100px;">
                                                    <input type="number" name="quantite" value="{{ $item['quantite'] }}" 
                                                           min="1" max="{{ $item['en_stock'] ?? '99' }}" 
                                                           class="form-control border-0 text-center fw-bold bg-light" 
                                                           onchange="this.form.submit()">
                                                </div>
                                            </form>
                                            @if(isset($item['en_stock']) && $item['en_stock'] < 10)
                                                <div class="x-small text-danger mt-1 fw-bold">Reste: {{ $item['en_stock'] }}</div>
                                            @endif
                                        </td>
                                        <td class="py-4 text-end fw-bold text-dark">
                                            {{ number_format($item['prix'] * $item['quantite'], 2) }} MAD
                                        </td>
                                        <td class="pe-4 py-4 text-end">
                                            <form action="{{ route('cart.remove', $id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger border-0 rounded-circle p-2 hover-elevate" title="Supprimer">
                                                    <i class="bi bi-trash fs-5"></i>
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="d-flex justify-content-between">
                    <a href="{{ route('products.index') }}" class="btn btn-outline-dark rounded-pill px-4 hover-elevate">
                        <i class="bi bi-arrow-left me-2"></i> Continuer mes achats
                    </a>
                    <form action="{{ route('cart.clear') }}" method="POST" class="d-inline text-end">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-link text-danger text-decoration-none small hover-underline" onclick="return confirm('Vider tout le panier ?')">
                            <i class="bi bi-x-circle me-1"></i> Vider le panier
                        </button>
                    </form>
                </div>
            </div>

            <!-- Order Summary Column -->
            <div class="col-lg-4">
                <div class="sticky-top" style="top: 2rem; z-index: 10;">
                    @auth
                        <div class="card border-0 shadow rounded-4 bg-primary text-white overflow-hidden mb-4">
                            <div class="card-body p-4">
                                <h5 class="fw-bold mb-4">Résumé de la commande</h5>
                                <div class="d-flex justify-content-between mb-3 opacity-75">
                                    <span>Sous-total</span>
                                    <span>{{ number_format($total, 2) }} MAD</span>
                                </div>
                                <div class="d-flex justify-content-between mb-4 opacity-75">
                                    <span>Frais de livraison</span>
                                    <span class="badge bg-white text-primary">Offert</span>
                                </div>
                                <hr class="bg-white opacity-25">
                                <div class="d-flex justify-content-between mb-4">
                                    <span class="h5 fw-bold">TOTAL</span>
                                    <span class="h4 fw-black mb-0">{{ number_format($total, 2) }} MAD</span>
                                </div>
                                <a href="{{ route('checkout') }}" class="btn btn-white w-100 rounded-pill py-3 fw-bold shadow hover-elevate">
                                    Passer à la caisse <i class="bi bi-chevron-right ms-2"></i>
                                </a>
                            </div>
                        </div>
                    @else
                        <div class="card border-0 shadow-sm rounded-4 bg-white overflow-hidden mb-4">
                            <div class="card-header bg-primary text-white py-3">
                                <h5 class="mb-0 fw-bold"><i class="bi bi-lightning-charge-fill me-2"></i> Commande Express</h5>
                            </div>
                            <div class="card-body p-4">
                                <form action="{{ route('orders.store') }}" method="POST" id="guest-order-form">
                                    @csrf
                                    <div class="row g-3">
                                        <div class="col-6">
                                            <div class="form-floating mb-3">
                                                <input type="text" name="prenom_client" class="form-control border-0 bg-light rounded-3" id="prenom" placeholder="Prénom" required>
                                                <label for="prenom">Prénom</label>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-floating mb-3">
                                                <input type="text" name="name_client" class="form-control border-0 bg-light rounded-3" id="nom" placeholder="Nom" required>
                                                <label for="nom">Nom</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-floating mb-3">
                                        <input type="text" name="telephone_client" class="form-control border-0 bg-light rounded-3" id="tel" placeholder="Téléphone" required>
                                        <label for="tel">Téléphone</label>
                                    </div>
                                    <div class="form-floating mb-4">
                                        <textarea name="adresse_client" class="form-control border-0 bg-light rounded-3" style="height: 100px" id="addr" placeholder="Adresse" required></textarea>
                                        <label for="addr">Adresse de livraison</label>
                                    </div>

                                    <div class="d-flex justify-content-between mb-4 border-top pt-3">
                                        <span class="h5 fw-bold">TOTAL</span>
                                        <span class="h4 fw-black text-primary mb-0">{{ number_format($total, 2) }} MAD</span>
                                    </div>

                                    <button type="submit" class="btn btn-success w-100 rounded-pill py-3 fw-bold shadow-sm hover-elevate mb-3">
                                        Valider ma commande <i class="bi bi-check-circle ms-2"></i>
                                    </button>
                                    <p class="text-center small text-muted mb-0">
                                        Déjà client ? <a href="{{ route('login') }}" class="text-primary fw-bold text-decoration-none">Connectez-vous</a>
                                    </p>
                                </form>
                            </div>
                        </div>
                    @endauth

                    <div class="p-4 bg-light rounded-4 border">
                        <div class="d-flex align-items-center mb-3">
                            <i class="bi bi-shield-check text-success fs-3 me-3"></i>
                            <div>
                                <div class="fw-bold small">Paiement 100% sécurisé</div>
                                <div class="text-muted x-small">Transaction cryptée et protégée.</div>
                            </div>
                        </div>
                        <div class="d-flex align-items-center">
                            <i class="bi bi-info-circle text-primary fs-3 me-3"></i>
                            <div>
                                <div class="fw-bold small">Support client</div>
                                <div class="text-muted x-small">Une question ? Appelez le {{ $adminContact->telephone ?? '06 00 00 00 00' }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

<style>
    .fw-black { font-weight: 900; }
    .x-small { font-size: 0.75rem; }
    .btn-white { background-color: white; color: var(--bs-primary); border: none; }
    .btn-white:hover { background-color: #f8f9fa; color: var(--bs-primary-dark); }
    .hover-elevate { transition: all 0.2s ease; }
    .hover-elevate:hover { transform: translateY(-2px); box-shadow: 0 4px 8px rgba(0,0,0,0.1) !important; }
    .hover-underline:hover { text-decoration: underline !important; }
    .sticky-top { transition: top 0.3s ease; }
</style>
@endsection
