@extends('layouts.app')

@section('content')
<div class="row mb-5">
    <div class="col-12">
        <div class="p-5 mb-4 bg-dark text-white rounded-3 shadow-lg overflow-hidden position-relative" style="background: linear-gradient(45deg, #1a1a1a 0%, #333 100%);">
            <div class="container-fluid py-5 position-relative" style="z-index: 2;">
                <h1 class="display-3 fw-bold mb-3">Expert Auto & Pneus</h1>
                <p class="col-md-8 fs-4 mb-4">La meilleure sélection de pneus, jantes et pièces détachées pour votre véhicule. Qualité certifiée et montage expert.</p>
                <a href="{{ route('products.index') }}" class="btn btn-primary btn-lg px-5 py-3 rounded-pill shadow">Découvrir le catalogue</a>
            </div>
            <div class="position-absolute end-0 bottom-0 opacity-25 p-5">
                <i class="bi bi-gear-fill" style="font-size: 200px;"></i>
            </div>
        </div>
    </div>
</div>

<h2 class="text-center mb-5 fw-bold">Nos Catégories</h2>
<div class="row g-4 mb-5">
    @foreach($categories as $category)
    <div class="col-md-3">
        <a href="{{ route('category.show', $category->slug) }}" class="text-decoration-none">
            <div class="card h-100 border-0 shadow-sm transition-hover text-center p-4 rounded-4 bg-white">
                <div class="mb-3">
                    <i class="bi {{ $category->icon ?? 'bi-box' }} text-primary display-4"></i>
                </div>
                <h4 class="text-dark fw-bold mb-0">{{ $category->name }}</h4>
                <p class="text-muted small mt-2">Voir tous les articles</p>
            </div>
        </a>
    </div>
    @endforeach
</div>

<div class="d-flex justify-content-between align-items-center mb-4 mt-5">
    <h3 class="fw-bold mb-0">Produits Phares</h3>
    <a href="{{ route('products.index') }}" class="text-primary text-decoration-none fw-bold">Tout voir <i class="bi bi-arrow-right"></i></a>
</div>

<div class="row g-4 mb-5">
    @foreach($featuredProducts as $product)
    <div class="col-md-3">
        <div class="card h-100 border-0 shadow-sm rounded-4 overflow-hidden product-card">
            <div class="position-relative">
                @if($product->image)
                    <img src="{{ asset('storage/pneus/' . $product->image) }}" class="card-img-top" alt="{{ $product->name }}" style="height: 200px; object-fit: cover;">
                @else
                    <div class="bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                        <i class="bi bi-image text-secondary display-1"></i>
                    </div>
                @endif
                <div class="position-absolute top-0 end-0 p-2">
                    <span class="badge bg-white text-dark shadow-sm rounded-pill px-3">{{ number_format($product->prix_actuel, 2) }} MAD</span>
                </div>
            </div>
            <div class="card-body p-3">
                <h6 class="text-muted mb-1">{{ $product->marque }}</h6>
                <h5 class="card-title fw-bold text-truncate">{{ $product->name }}</h5>
                <p class="text-muted x-small mb-3 text-truncate">
                    @if($product->dimension)
                        {{ $product->dimension }}
                    @else
                        {{ Str::limit($product->description, 50) }}
                    @endif
                </p>
                <div class="d-grid">
                    <a href="{{ route('products.show', $product->id) }}" class="btn btn-outline-primary rounded-pill btn-sm">Détails</a>
                </div>
            </div>
        </div>
    </div>
    @endforeach
</div>

<style>
    .transition-hover {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
    .transition-hover:hover {
        transform: translateY(-10px);
        box-shadow: 0 1rem 3rem rgba(0,0,0,.175)!important;
    }
    .product-card {
        transition: transform 0.2s ease;
    }
    .product-card:hover {
        transform: scale(1.02);
    }
    .x-small { font-size: 0.8rem; }
</style>
@endsection
