<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestion Pneus</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark shadow-sm py-3">
        <div class="container">
            <a class="navbar-brand fw-bold fs-3" href="{{ route('home') }}">
                <i class="bi bi-gear-wide-connected text-primary"></i> Pneu<span class="text-primary">Shop</span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                        <a class="nav-link {{ Route::is('home') ? 'active' : '' }}" href="{{ route('home') }}">Accueil</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle {{ request()->is('category/*') ? 'active' : '' }}" href="#" id="navbarDropdownCategories" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            Catégories
                        </a>
                        <ul class="dropdown-menu border-0 shadow" aria-labelledby="navbarDropdownCategories">
                            @foreach($globalCategories as $cat)
                                <li>
                                    <a class="dropdown-item d-flex align-items-center {{ request()->is('category/'.$cat->slug) ? 'active bg-primary text-white' : '' }}" href="{{ route('category.show', $cat->slug) }}">
                                        @if($cat->icon)
                                            <i class="bi {{ $cat->icon }} me-2"></i>
                                        @endif
                                        {{ $cat->name }}
                                    </a>
                                </li>
                            @endforeach
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item" href="{{ route('products.index') }}">
                                    <i class="bi bi-grid-3x3-gap me-2"></i> Tous les produits
                                </a>
                            </li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ Route::is('products.index') ? 'active' : '' }}" href="{{ route('products.index') }}">Boutique</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ Route::is('pages.delivery') ? 'active' : '' }}" href="{{ route('pages.delivery') }}">Livraison</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ Route::is('pages.about') ? 'active' : '' }}" href="{{ route('pages.about') }}">À propos</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ Route::is('pages.contact') ? 'active' : '' }}" href="{{ route('pages.contact') }}">Contact</a>
                    </li>
                </ul>
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item me-3">
                        <a class="nav-link position-relative" href="{{ route('cart.index') }}">
                            <i class="bi bi-cart3 fs-5"></i>
                            @if(session('cart') && count(session('cart')) > 0)
                                <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-primary" style="font-size: 0.6rem;">
                                    {{ count(session('cart')) }}
                                </span>
                            @endif
                        </a>
                    </li>
                    @auth
                        @if(Auth::user()->role === 'admin')
                            <li class="nav-item me-2">
                                <a class="btn btn-sm btn-outline-warning rounded-pill px-3" href="{{ route('admin.dashboard') }}">
                                    <i class="bi bi-speedometer2"></i> Admin
                                </a>
                            </li>
                        @endif
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('orders.index') }}">Mes commandes</a>
                        </li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle fw-bold text-white" href="#" role="button" data-bs-toggle="dropdown">
                                Bonjour, {{ Auth::user()->nom }}
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end border-0 shadow">
                                <li>
                                    <a class="dropdown-item" href="{{ route('profile.edit') }}">
                                        <i class="bi bi-person-circle me-2"></i> Mon Profil
                                    </a>
                                </li>
                                <li><hr class="dropdown-divider"></li>
                                <li>
                                    <form action="{{ route('logout') }}" method="POST">
                                        @csrf
                                        <button type="submit" class="dropdown-item text-danger">
                                            <i class="bi bi-box-arrow-right me-2"></i> Déconnexion
                                        </button>
                                    </form>
                                </li>
                            </ul>
                        </li>
                    @else
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('login') }}">Connexion</a>
                        </li>
                        <li class="nav-item">
                            <a class="btn btn-primary btn-sm rounded-pill px-4 ms-2" href="{{ route('register') }}">Inscription</a>
                        </li>
                    @endauth
                </ul>
            </div>
        </div>
    </nav>

    <div class="container mt-4">
        @if(session('error'))
            <div class="alert alert-danger border-0 shadow-sm rounded-4 mb-4">
                <i class="bi bi-exclamation-triangle me-2"></i> {{ session('error') }}
            </div>
        @endif
        
        @if(session('success'))
            <div class="alert alert-success border-0 shadow-sm rounded-4 mb-4">
                <i class="bi bi-check-circle me-2"></i> {{ session('success') }}
            </div>
        @endif

        @yield('content')
    </div>

    <footer class="bg-dark text-white py-5 mt-auto">
        <div class="container">
            <div class="row g-4">
                <div class="col-lg-4">
                    <a class="navbar-brand fw-bold fs-3 text-white d-block mb-3" href="{{ route('home') }}">
                        <i class="bi bi-gear-wide-connected text-primary"></i> Pneu<span class="text-primary">Shop</span>
                    </a>
                    <p class="text-white-50">Votre expert en pneumatiques. Qualité, sécurité et service professionnel pour tous vos besoins mobiles.</p>
                    <div class="d-flex gap-3 mt-4">
                        <a href="#" class="text-white opacity-50 hover-opacity-100"><i class="bi bi-facebook fs-5"></i></a>
                        <a href="#" class="text-white opacity-50 hover-opacity-100"><i class="bi bi-instagram fs-5"></i></a>
                        <a href="#" class="text-white opacity-50 hover-opacity-100"><i class="bi bi-whatsapp fs-5"></i></a>
                    </div>
                </div>
                <div class="col-6 col-lg-2">
                    <h6 class="fw-bold mb-3">Boutique</h6>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="{{ route('products.index') }}" class="text-white-50 text-decoration-none hover-white">Tous les produits</a></li>
                        <li class="mb-2"><a href="{{ route('cart.index') }}" class="text-white-50 text-decoration-none hover-white">Mon Panier</a></li>
                        <li class="mb-2"><a href="{{ route('orders.index') }}" class="text-white-50 text-decoration-none hover-white">Mes commandes</a></li>
                    </ul>
                </div>
                <div class="col-6 col-lg-2">
                    <h6 class="fw-bold mb-3">Informations</h6>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="{{ route('pages.about') }}" class="text-white-50 text-decoration-none hover-white">À propos</a></li>
                        <li class="mb-2"><a href="{{ route('pages.delivery') }}" class="text-white-50 text-decoration-none hover-white">Livraison</a></li>
                        <li class="mb-2"><a href="{{ route('pages.contact') }}" class="text-white-50 text-decoration-none hover-white">Contact</a></li>
                    </ul>
                </div>
                <div class="col-lg-4">
                    <h6 class="fw-bold mb-3">Besoins d'aide ?</h6>
                    <div class="d-flex align-items-center mb-3">
                        <i class="bi bi-telephone-fill text-primary fs-5 me-3"></i>
                        <div>
                            <div class="small text-white-50">Service client</div>
                            <div class="text-white">{{ $adminContact->telephone ?? '06 00 00 00 00' }}</div>
                        </div>
                    </div>
                    <div class="d-flex align-items-center">
                        <i class="bi bi-envelope-at-fill text-primary fs-5 me-3"></i>
                        <div>
                            <div class="small text-white-50">Email</div>
                            <div class="text-white">{{ $adminContact->email ?? 'contact@pneushop.ma' }}</div>
                        </div>
                    </div>
                </div>
            </div>
            <hr class="my-5 border-white border-opacity-10">
            <div class="row align-items-center">
                <div class="col-md-12 text-center">
                    <p class="text-white-50 small mb-0">&copy; {{ date('Y') }} PneuShop. Tous droits réservés.</p>
                </div>
            </div>
        </div>
    </footer>

    <style>
        body { min-height: 100vh; display: flex; flex-direction: column; }
        .hover-white:hover { color: white !important; }
        .hover-opacity-100:hover { opacity: 1 !important; }
        .grayscale { filter: grayscale(1); }
    </style>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
