@extends('layouts.app')

@section('content')
<div class="container py-5">
    <div class="mb-5">
        <h1 class="fw-black text-dark mb-1">Finaliser votre commande</h1>
        <p class="text-muted">Vérifiez vos informations et confirmez vos achats en un clic.</p>
    </div>

    <div class="row g-4">
        <!-- Left Column: Delivery Info -->
        <div class="col-lg-7">
            <div class="card border-0 shadow-sm rounded-4 h-100 bg-white">
                <div class="card-header bg-white py-4 px-4 border-0">
                    <h5 class="fw-bold text-dark mb-0 d-flex align-items-center">
                        <i class="bi bi-geo-alt text-primary me-2"></i> Informations de livraison
                    </h5>
                </div>
                <div class="card-body p-4 pt-0">
                    @auth
                        <div class="p-4 bg-light rounded-4 border-0 mb-3">
                            <div class="row g-4 text-dark">
                                <div class="col-md-6 text-dark text-opacity-100">
                                    <label class="small text-muted text-uppercase fw-bold d-block mb-1">Client</label>
                                    <div class="fw-bold fs-5 text-dark">{{ Auth::user()->name }} {{ Auth::user()->prenom }}</div>
                                </div>
                                <div class="col-md-6">
                                    <label class="small text-muted text-uppercase fw-bold d-block mb-1">Téléphone</label>
                                    <div class="fw-bold fs-5 text-dark">{{ Auth::user()->telephone }}</div>
                                </div>
                                <div class="col-12">
                                    <label class="small text-muted text-uppercase fw-bold d-block mb-1">Adresse complète</label>
                                    <div class="fw-bold fs-6 text-dark">{{ Auth::user()->adresse }}</div>
                                </div>
                            </div>
                        </div>
                        <div class="alert alert-info border-0 rounded-3 small">
                            <i class="bi bi-info-circle me-1 text-dark"></i> Ces informations seront utilisées pour la livraison. Notre équipe vous appellera pour confirmer.
                        </div>
                    @else
                        <div class="p-3 bg-primary bg-opacity-10 text-primary rounded-4 mb-4 small fw-semibold">
                            <i class="bi bi-info-circle-fill me-2 "></i> Veuillez remplir les informations ci-dessous pour que notre équipe puisse vous contacter et valider la commande.
                        </div>
                        
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="prenom_client" class="form-control border-0 bg-light rounded-3" id="prenom" placeholder="Prénom" required form="checkout-form">
                                    <label for="prenom">Prénom</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="name_client" class="form-control border-0 bg-light rounded-3" id="nom" placeholder="Nom" required form="checkout-form">
                                    <label for="nom">Nom</label>
                                </div>
                            </div>
                        </div>
                        <div class="form-floating mb-3">
                            <input type="text" name="telephone_client" class="form-control border-0 bg-light rounded-3" id="tel" placeholder="Téléphone" required form="checkout-form" maxlength="10" minlength="10" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10)" title="Le numéro doit contenir exactement 10 chiffres">
                            <label for="tel">Téléphone</label>
                        </div>
                        <div class="form-floating mb-0">
                            <textarea name="adresse_client" class="form-control border-0 bg-light rounded-3" style="height: 120px" id="addr" placeholder="Adresse" required form="checkout-form"></textarea>
                            <label for="addr">Adresse de livraison complète</label>
                        </div>
                    @endauth
                </div>
            </div>
        </div>

        <!-- Right Column: Recap & Total -->
        <div class="col-lg-5">
            <div class="card border-0 shadow rounded-4 bg-white overflow-hidden">
                <div class="card-header bg-dark text-white py-4 px-4 border-0">
                    <h5 class="fw-bold mb-0">Récapitulatif de commande</h5>
                </div>
                <div class="card-body p-4">
                    <div class="mb-4">
                        @foreach($cart as $id => $item)
                        <div class="d-flex align-items-start mb-3 pb-3 @if(!$loop->last) border-bottom border-light @endif">
                            <div class="flex-shrink-0">
                                @if(isset($item['image']) && $item['image'] && Storage::disk('public')->exists('pneus/' . $item['image']))
                                    <img src="{{ asset('storage/pneus/' . $item['image']) }}" class="rounded bg-light" width="50" height="50" style="object-fit: contain;">
                                @else
                                    <div class="bg-light rounded d-flex align-items-center justify-content-center" width="50" height="50">
                                        <i class="bi bi-image text-muted"></i>
                                    </div>
                                @endif
                            </div>
                            <div class="flex-grow-1 ms-3">
                                <div class="d-flex justify-content-between">
                                    <h6 class="mb-0 fw-bold text-dark text-truncate" style="max-width: 200px;">{{ $item['nom'] }}</h6>
                                    <span class="fw-bold text-dark">{{ number_format($item['prix'] * $item['quantite'], 2) }} MAD</span>
                                </div>
                                <div class="small text-muted">{{ $item['quantite'] }} x {{ number_format($item['prix'], 2) }} MAD</div>
                            </div>
                        </div>
                        @endforeach
                    </div>

                    <div class="bg-light p-4 rounded-4 mb-4">
                        <div class="d-flex justify-content-between mb-2 text-muted small">
                            <span>Sous-total</span>
                            <span>{{ number_format($total, 2) }} MAD</span>
                        </div>
                        <div class="d-flex justify-content-between mb-3 text-muted small">
                            <span>Livraison</span>
                            <span class="text-success fw-bold">Gratuite</span>
                        </div>
                        <div class="border-top pt-3 d-flex justify-content-between">
                            <span class="h5 fw-bold text-dark">Total à payer</span>
                            <span class="h4 fw-black text-primary mb-0">{{ number_format($total, 2) }} MAD</span>
                        </div>
                    </div>

                    <form action="{{ route('orders.store') }}" method="POST" id="checkout-form">
                        @csrf
                        <button type="submit" class="btn btn-primary w-100 rounded-pill py-3 fw-bold shadow hover-elevate">
                            <i class="bi bi-check2-circle me-2"></i> Confirmer ma commande
                        </button>
                    </form>
                    
                    <a href="{{ route('cart.index') }}" class="btn btn-link w-100 text-muted mt-3 text-decoration-none small">
                        <i class="bi bi-arrow-left me-1 "></i> Modifier mon panier
                    </a>
                </div>
            </div>

            <div class="mt-4 p-4 rounded-4 border bg-white shadow-sm">
                <div class="d-flex align-items-center">
                    <div class="bg-success bg-opacity-10 p-3 rounded-circle me-3">
                        <i class="bi bi-telephone text-success fs-4"></i>
                    </div>
                    <div>
                        <div class="fw-bold text-dark small">Des questions ?</div>
                        <div class="text-muted x-small">Appelez-nous au {{ $adminContact->telephone ?? '06 00 00 00 00' }} pour une assistance directe.</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .fw-black { font-weight: 900; }
    .x-small { font-size: 0.75rem; }
    .hover-elevate { transition: all 0.2s ease; }
    .hover-elevate:hover { transform: translateY(-2px); box-shadow: 0 4px 12px rgba(0,0,0,0.1) !important; }
</style>
@endsection
