@extends('layouts.app')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- Success Hero Section -->
            <div class="text-center mb-5">
                <div class="mb-4">
                    <span class="bg-success bg-opacity-10 text-success p-4 rounded-circle d-inline-block shadow-sm">
                        <i class="bi bi-check2-all display-3"></i>
                    </span>
                </div>
                <h1 class="fw-black text-dark mb-2">Commande Enregistrée !</h1>
                <p class="text-muted fs-5">Votre commande <span class="fw-bold text-primary">#{{ $commande->id }}</span> est maintenant en cours de traitement.</p>
            </div>

            <div class="row g-4">
                <!-- Left Column: Details -->
                <div class="col-md-4">
                    <div class="card border-0 shadow-sm rounded-4 h-100 bg-white">
                        <div class="card-body p-4">
                            <h5 class="fw-bold text-dark mb-4 pb-2 border-bottom">Informations</h5>
                            
                            <div class="mb-4">
                                <label class="small text-muted text-uppercase fw-bold mb-1">Date de commande</label>
                                <div class="fw-semibold">{{ $commande->created_at->format('d F Y') }}</div>
                                <div class="small text-muted">{{ $commande->created_at->format('H:i') }}</div>
                            </div>

                            <div class="mb-4">
                                <label class="small text-muted text-uppercase fw-bold mb-1">Statut</label>
                                <div>
                                    @switch($commande->statut)
                                        @case('en_attente')
                                            <span class="badge rounded-pill px-3 py-2 fw-semibold" style="background-color: #fff3cd; color: #856404;">En attente</span>
                                            @break
                                        @case('en_cours')
                                            <span class="badge rounded-pill px-3 py-2 fw-semibold" style="background-color: #d1ecf1; color: #0c5460;">En cours</span>
                                            @break
                                        @case('livres')
                                            <span class="badge rounded-pill px-3 py-2 fw-semibold" style="background-color: #d4edda; color: #155724;">Livrée</span>
                                            @break
                                        @default
                                            <span class="badge bg-light text-dark rounded-pill px-3 py-2">{{ $commande->statut }}</span>
                                    @endswitch
                                </div>
                            </div>

                            <div class="mb-0">
                                <label class="small text-muted text-uppercase fw-bold mb-1">Contact validation</label>
                                <div class="p-3 bg-light rounded-3">
                                    <div class="fw-bold text-dark fs-5">{{ $commande->telephone_client ?? Auth::user()->telephone }}</div>
                                    <small class="text-muted"><i class="bi bi-telephone-inbound me-1"></i> Notre équipe vous appellera ici.</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Column: Products Table -->
                <div class="col-md-8">
                    <div class="card border-0 shadow-sm rounded-4 bg-white overflow-hidden">
                        <div class="p-4 bg-light border-bottom">
                            <h5 class="fw-bold text-dark mb-0">Résumé des articles</h5>
                        </div>
                        <div class="table-responsive">
                            <table class="table align-middle mb-0">
                                <thead class="small text-uppercase text-muted fw-bold">
                                    <tr>
                                        <th class="ps-4 py-3 border-0">Produit</th>
                                        <th class="py-3 border-0 text-center">Quantité</th>
                                        <th class="pe-4 py-3 border-0 text-end">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($commande->products as $product)
                                        <tr>
                                            <td class="ps-4 py-3">
                                                <div class="d-flex align-items-center">
                                                    @if($product->image && Storage::disk('public')->exists('pneus/' . $product->image))
                                                        <img src="{{ asset('storage/pneus/' . $product->image) }}" class="rounded me-3" width="40" height="40" style="object-fit: contain;">
                                                    @else
                                                        <div class="bg-light rounded d-flex align-items-center justify-content-center me-3" width="40" height="40">
                                                            <i class="bi bi-image text-muted"></i>
                                                        </div>
                                                    @endif
                                                    <div>
                                                        <div class="fw-bold text-dark text-truncate" style="max-width: 250px;">{{ $product->name }}</div>
                                                        <small class="text-muted">{{ number_format($product->pivot->prix_unitaire, 2) }} MAD / unité</small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="py-3 text-center">
                                                <span class="badge bg-light text-dark rounded-pill px-3 py-2 fw-bold">{{ $product->pivot->quantite }}</span>
                                            </td>
                                            <td class="pe-4 py-3 text-end fw-bold text-dark">
                                                {{ number_format($product->pivot->prix_unitaire * $product->pivot->quantite, 2) }} MAD
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot class="border-top-2">
                                    <tr class="bg-primary bg-opacity-5 text-primary">
                                        <td colspan="2" class="ps-4 py-4 fw-bold fs-5 border-0">Total Payé</td>
                                        <td class="pe-4 py-4 text-end fw-black fs-4 border-0">{{ number_format($commande->total, 2) }} MAD</td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>

                    <div class="mt-4 d-flex gap-3">
                        <a href="{{ route('products.index') }}" class="btn btn-outline-dark rounded-pill px-4 py-2 hover-elevate">
                            <i class="bi bi-arrow-left me-2"></i> Continuer mes achats
                        </a>
                        @auth
                        <a href="{{ route('orders.index') }}" class="btn btn-primary rounded-pill px-4 py-2 shadow transition-all hover-elevate">
                            <i class="bi bi-list-check me-2"></i> Voir mes commandes
                        </a>
                        @endauth
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .fw-black { font-weight: 900; }
    .border-top-2 { border-top: 2px solid #eee !important; }
    .hover-elevate { transition: all 0.2s ease; }
    .hover-elevate:hover { transform: translateY(-2px); box-shadow: 0 4px 8px rgba(0,0,0,0.1) !important; }
</style>
@endsection
