@extends('layouts.app')

@section('content')
<div class="container py-5">
    <div class="d-flex justify-content-between align-items-center mb-5">
        <div>
            <h1 class="fw-bold text-dark mb-1">Mes commandes</h1>
            <p class="text-muted mb-0">Suivez l'état de vos achats en temps réel.</p>
        </div>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Accueil</a></li>
                <li class="breadcrumb-item active">Mes commandes</li>
            </ol>
        </nav>
    </div>

    @if($commandes->isEmpty())
        <div class="card border-0 shadow-sm rounded-4 py-5 text-center">
            <div class="card-body py-5">
                <div class="mb-4">
                    <i class="bi bi-bag-x text-muted display-1 opacity-25"></i>
                </div>
                <h3 class="fw-bold text-dark">Aucune commande pour le moment</h3>
                <p class="text-muted mb-4">Vous n'avez pas encore passé de commande sur notre boutique.</p>
                <a href="{{ route('products.index') }}" class="btn btn-primary rounded-pill px-5 shadow-sm">
                    Découvrir notre catalogue
                </a>
            </div>
        </div>
    @else
        <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-light">
                        <tr>
                            <th class="ps-4 py-3 border-0 text-uppercase small fw-bold text-muted">Référence</th>
                            <th class="py-3 border-0 text-uppercase small fw-bold text-muted">Date</th>
                            <th class="py-3 border-0 text-uppercase small fw-bold text-muted">Montant Total</th>
                            <th class="py-3 border-0 text-uppercase small fw-bold text-muted text-center">Statut</th>
                            <th class="pe-4 py-3 border-0 text-uppercase small fw-bold text-muted text-end">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($commandes as $commande)
                            <tr>
                                <td class="ps-4 py-4">
                                    <span class="fw-bold text-dark">#{{ $commande->id }}</span>
                                </td>
                                <td class="py-4 text-muted">
                                    {{ $commande->created_at->format('d M Y') }}
                                    <div class="small opacity-75">{{ $commande->created_at->format('H:i') }}</div>
                                </td>
                                <td class="py-4">
                                    <span class="h6 mb-0 fw-bold text-primary">{{ number_format($commande->total, 2) }} MAD</span>
                                </td>
                                <td class="py-4 text-center">
                                    @switch($commande->statut)
                                        @case('en_attente')
                                            <span class="badge rounded-pill px-3 py-2 fw-semibold" style="background-color: #fff3cd; color: #856404;">
                                                <i class="bi bi-clock-history me-1"></i> En attente
                                            </span>
                                            @break
                                        @case('en_cours')
                                            <span class="badge rounded-pill px-3 py-2 fw-semibold" style="background-color: #d1ecf1; color: #0c5460;">
                                                <i class="bi bi-truck me-1"></i> En cours
                                            </span>
                                            @break
                                        @case('livres')
                                            <span class="badge rounded-pill px-3 py-2 fw-semibold" style="background-color: #d4edda; color: #155724;">
                                                <i class="bi bi-check2-circle me-1"></i> Livrée
                                            </span>
                                            @break
                                        @case('annulee')
                                            <span class="badge rounded-pill px-3 py-2 fw-semibold" style="background-color: #f8d7da; color: #721c24;">
                                                <i class="bi bi-x-circle me-1"></i> Annulée
                                            </span>
                                            @break
                                    @endswitch
                                </td>
                                <td class="pe-4 py-4 text-end">
                                    <a href="{{ route('orders.confirmation', $commande->id) }}" class="btn btn-sm btn-outline-dark rounded-pill px-3 shadow-sm hover-elevate">
                                        <i class="bi bi-search me-1"></i> Détails
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endif
</div>

<style>
    .hover-elevate { transition: all 0.2s ease; }
    .hover-elevate:hover { transform: translateY(-2px); box-shadow: 0 4px 8px rgba(0,0,0,0.1) !important; }
</style>
@endsection
