@extends('layouts.app')

@section('content')
<div class="bg-dark text-white py-5 mb-5" style="background: linear-gradient(rgba(0,0,0,0.7), rgba(0,0,0,0.7)), url('https://images.unsplash.com/photo-1486262715619-67b85e0b08d3?ixlib=rb-1.2.1&auto=format&fit=crop&w=1920&q=80') center/cover;">
    <div class="container py-5 text-center">
        <h1 class="display-3 fw-black mb-3">Notre Histoire</h1>
        <p class="lead text-white-50 mx-auto" style="max-width: 700px;">Découvrez PneuShop, votre partenaire de confiance pour une route plus sûre depuis plus de 10 ans.</p>
    </div>
</div>

<div class="container mb-5">
    <div class="row align-items-center mb-5 pb-5">
        <div class="col-lg-6 mb-4 mb-lg-0">
            <img src="{{ asset('storage/team/team.png') }}" alt="Notre équipe PneuShop" class="img-fluid rounded-4 shadow-lg">
        </div>
        <div class="col-lg-6 px-lg-5">
            <h2 class="fw-bold mb-4">Plus qu'un simple garage</h2>
            <p class="text-muted mb-4 fs-5">Chez PneuShop, nous comprenons que vos pneus sont le seul point de contact entre votre véhicule et la route. Votre sécurité est notre priorité absolue.</p>
            <p class="text-muted">Fondée avec une passion pour l'automobile et le service client, notre entreprise s'est développée pour devenir le leader de la vente et du montage de pneus au Maroc. Nous sélectionnons rigoureusement nos produits parmi les plus grandes marques mondiales pour vous garantir performance et durabilité.</p>
            <div class="row mt-4 g-4">
                <div class="col-6">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-patch-check-fill text-primary fs-3 me-3"></i>
                        <div>
                            <div class="fw-bold">Produits Certifiés</div>
                            <div class="small text-muted">100% Authentiques</div>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="d-flex align-items-center">
                        <i class="bi bi-tools text-primary fs-3 me-3"></i>
                        <div>
                            <div class="fw-bold">Montage Expert</div>
                            <div class="small text-muted">Équipe qualifiée</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 text-center">
        <div class="col-md-4">
            <div class="p-5 bg-light rounded-4 h-100 border-0 shadow-sm transition-hover">
                <div class="bg-white rounded-circle d-inline-flex align-items-center justify-content-center mb-4 shadow-sm" style="width: 80px; height: 80px;">
                    <i class="bi bi-award text-primary fs-1"></i>
                </div>
                <h4 class="fw-bold mb-3">Qualité Premium</h4>
                <p class="text-muted">Nous ne proposons que des marques reconnues pour leur excellence et leur fiabilité sur la route.</p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="p-5 bg-light rounded-4 h-100 border-0 shadow-sm transition-hover">
                <div class="bg-white rounded-circle d-inline-flex align-items-center justify-content-center mb-4 shadow-sm" style="width: 80px; height: 80px;">
                    <i class="bi bi-currency-dollar text-primary fs-1"></i>
                </div>
                <h4 class="fw-bold mb-3">Meilleurs Prix</h4>
                <p class="text-muted">Nous négocions directement avec les fabricants pour vous offrir les tarifs les plus compétitifs du marché.</p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="p-5 bg-light rounded-4 h-100 border-0 shadow-sm transition-hover">
                <div class="bg-white rounded-circle d-inline-flex align-items-center justify-content-center mb-4 shadow-sm" style="width: 80px; height: 80px;">
                    <i class="bi bi-headset text-primary fs-1"></i>
                </div>
                <h4 class="fw-bold mb-3">Service Client</h4>
                <p class="text-muted">Notre équipe d'experts est disponible 7j/7 pour vous conseiller et répondre à toutes vos questions.</p>
            </div>
        </div>
    </div>
</div>

<style>
    .fw-black { font-weight: 900; }
    .transition-hover { transition: transform 0.3s ease; }
    .transition-hover:hover { transform: translateY(-5px); }
</style>
@endsection
