@extends('layouts.app')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card border-0 shadow-lg rounded-4 overflow-hidden">
                <div class="row g-0">
                    <div class="col-lg-5 bg-primary text-white p-5 d-flex flex-column justify-content-between position-relative overflow-hidden">
                        <div class="position-absolute top-0 start-0 w-100 h-100 bg-dark opacity-10"></div>
                        <div class="position-relative z-1">
                            <h2 class="fw-bold mb-4">Contactez-nous</h2>
                            <p class="mb-5 text-white-50">Une question sur un produit ? Besoin d'aide pour votre commande ? Notre équipe est là pour vous.</p>
                            
                            <div class="d-flex align-items-center mb-4">
                                <i class="bi bi-geo-alt-fill fs-4 me-3 opacity-75"></i>
                                <div>
                                    <h6 class="fw-bold mb-0">Adresse</h6>
                                    <span class="small text-white-50">{{ $adminContact->adresse ?? '123 Bd Zerktouni, Casablanca, Maroc' }}</span>
                                </div>
                            </div>
                            
                            <div class="d-flex align-items-center mb-4">
                                <i class="bi bi-telephone-fill fs-4 me-3 opacity-75"></i>
                                <div>
                                    <h6 class="fw-bold mb-0">Téléphone</h6>
                                    <span class="small text-white-50">{{ $adminContact->telephone ?? '06 00 00 00 00' }}</span>
                                </div>
                            </div>
                            
                            <div class="d-flex align-items-center mb-4">
                                <i class="bi bi-envelope-fill fs-4 me-3 opacity-75"></i>
                                <div>
                                    <h6 class="fw-bold mb-0">Email</h6>
                                    <span class="small text-white-50">{{ $adminContact->email ?? 'contact@pneushop.ma' }}</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="position-relative z-1 mt-5">
                            <div class="d-flex gap-3">
                                <a href="#" class="btn btn-outline-light rounded-circle p-2 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;"><i class="bi bi-facebook"></i></a>
                                <a href="#" class="btn btn-outline-light rounded-circle p-2 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;"><i class="bi bi-instagram"></i></a>
                                <a href="#" class="btn btn-outline-light rounded-circle p-2 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;"><i class="bi bi-whatsapp"></i></a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-7 p-5 bg-white">
                        <h3 class="fw-bold text-dark mb-4">Envoyez-nous un message</h3>
                        <form>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <div class="form-floating mb-3">
                                        <input type="text" class="form-control bg-light border-0 rounded-3" id="nom" placeholder="Nom">
                                        <label for="nom">Nom</label>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-floating mb-3">
                                        <input type="email" class="form-control bg-light border-0 rounded-3" id="email" placeholder="Email">
                                        <label for="email">Email</label>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-floating mb-3">
                                        <input type="text" class="form-control bg-light border-0 rounded-3" id="sujet" placeholder="Sujet">
                                        <label for="sujet">Sujet</label>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-floating mb-4">
                                        <textarea class="form-control bg-light border-0 rounded-3" placeholder="Message" id="message" style="height: 150px"></textarea>
                                        <label for="message">Votre message</label>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <button type="button" class="btn btn-dark w-100 py-3 rounded-pill fw-bold shadow-sm">
                                        Envoyer le message <i class="bi bi-send-fill ms-2"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
