@extends('layouts.app')

@section('content')
<div class="container py-5">
    <div class="text-center mb-5">
        <h1 class="fw-black mb-3">Livraison & Montage</h1>
        <p class="text-muted lead mx-auto" style="max-width: 600px;">Nous vous simplifions la vie. Recevez vos pneus chez vous ou faites-les monter dans l'un de nos centres partenaires.</p>
    </div>

    <div class="row g-4 justify-content-center mb-5">
        <div class="col-lg-10">
            <div class="card border-0 shadow rounded-4 overflow-hidden">
                <div class="row g-0">
                    <div class="col-md-5 bg-light d-none d-md-block" style="background: url('https://images.unsplash.com/photo-1616422285623-13ff0162193c?ixlib=rb-1.2.1&auto=format&fit=crop&w=800&q=80') center/cover;">
                    </div>
                    <div class="col-md-7">
                        <div class="p-5">
                            <div class="d-flex mb-4">
                                <div class="flex-shrink-0">
                                    <div class="bg-primary bg-opacity-10 text-primary rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                        <i class="bi bi-truck fs-4"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h4 class="fw-bold">Livraison à domicile</h4>
                                    <p class="text-muted small">Partout au Maroc</p>
                                    <p class="text-muted mb-0">Recevez vos pneus directement à l'adresse de votre choix (domicile ou bureau) sous 24h à 48h. La livraison est gratuite pour toute commande de 2 pneus ou plus.</p>
                                </div>
                            </div>
                            
                            <hr class="my-4 border-light">

                            <div class="d-flex mb-4">
                                <div class="flex-shrink-0">
                                    <div class="bg-success bg-opacity-10 text-success rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                        <i class="bi bi-tools fs-4"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h4 class="fw-bold">Montage en centre</h4>
                                    <p class="text-muted small">Réseau de +50 partenaires</p>
                                    <p class="text-muted mb-0">Choisissez la livraison dans l'un de nos centres de montage partenaires. Ils recevront vos pneus et vous contacteront pour fixer un rendez-vous.</p>
                                </div>
                            </div>

                            <hr class="my-4 border-light">

                            <div class="d-flex">
                                <div class="flex-shrink-0">
                                    <div class="bg-warning bg-opacity-10 text-warning rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                        <i class="bi bi-box-seam fs-4"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h4 class="fw-bold">Suivi de commande</h4>
                                    <p class="text-muted mb-0">Vous serez informé par SMS et email à chaque étape : validation, expédition et livraison.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 text-center py-5">
        <h3 class="fw-bold mb-4">Nos zones de livraison</h3>
        <div class="col-md-3">
            <div class="p-3 border rounded-3 bg-white">
                <h5 class="fw-bold mb-1">Casablanca & Régions</h5>
                <span class="badge bg-success rounded-pill">24h Express</span>
            </div>
        </div>
        <div class="col-md-3">
            <div class="p-3 border rounded-3 bg-white">
                <h5 class="fw-bold mb-1">Rabat & Nord</h5>
                <span class="badge bg-primary rounded-pill">24h - 48h</span>
            </div>
        </div>
        <div class="col-md-3">
            <div class="p-3 border rounded-3 bg-white">
                <h5 class="fw-bold mb-1">Marrakech & Sud</h5>
                <span class="badge bg-primary rounded-pill">48h</span>
            </div>
        </div>
        <div class="col-md-3">
            <div class="p-3 border rounded-3 bg-white">
                <h5 class="fw-bold mb-1">Fès & Oujda</h5>
                <span class="badge bg-primary rounded-pill">48h - 72h</span>
            </div>
        </div>
    </div>
</div>

<style>
    .fw-black { font-weight: 900; }
</style>
@endsection
