@extends('layouts.app')

@section('content')
<div class="container py-4">
    <!-- Breadcrumb -->
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">Accueil</a></li>
            <li class="breadcrumb-item active">{{ isset($category) ? $category->name : 'Catalogue' }}</li>
        </ol>
    </nav>

    <div class="row">
        <!-- Sidebar Filter -->
        <aside class="col-lg-3 mb-4">
            <div class="card border-0 shadow-sm rounded-4">
                <div class="card-header bg-white border-bottom-0 pt-4 px-4">
                    <h5 class="fw-bold mb-0">Filtres</h5>
                </div>
                <div class="card-body px-4 pb-4">
                    <form method="GET" action="{{ url()->current() }}" id="filterForm">
                        @if(request('category_id'))
                            <input type="hidden" name="category_id" value="{{ request('category_id') }}">
                        @endif
                        @if(request('search'))
                            <input type="hidden" name="search" value="{{ request('search') }}">
                        @endif

                        <!-- Price Filter -->
                        <div class="mb-4">
                            <label class="form-label fw-semibold mb-2">Prix</label>
                            <div class="d-flex align-items-center gap-2">
                                <input type="number" name="min_price" class="form-control form-control-sm" placeholder="{{ $minPriceLimit }}" value="{{ request('min_price') }}" min="0">
                                <span class="text-muted">-</span>
                                <input type="number" name="max_price" class="form-control form-control-sm" placeholder="{{ $maxPriceLimit }}" value="{{ request('max_price') }}" min="0">
                            </div>
                        </div>

                        <!-- Filter Groups -->
                        @php
                            $groups = [
                                'Marque' => ['items' => $marques, 'field' => 'marque'],
                                'Diamètre' => ['items' => $diametres, 'field' => 'diametre'],
                                'Largeur' => ['items' => $largeurs, 'field' => 'largeur'],
                                'Hauteur' => ['items' => $hauteurs, 'field' => 'hauteur'],
                                'Charge' => ['items' => $charges, 'field' => 'charge_index'],
                                'Vitesse' => ['items' => $vitesses, 'field' => 'vitesse_index'],
                                'Saison' => ['items' => $saisons, 'field' => 'saison'],
                            ];
                        @endphp

                        @foreach($groups as $label => $group)
                            @if($group['items']->count() > 0)
                            <div class="mb-4">
                                <h6 class="fw-bold mb-2">{{ $label }}</h6>
                                <div class="filter-group" style="max-height: 200px; overflow-y: auto;">
                                    @foreach($group['items'] as $item)
                                        @php
                                            $value = $item->{$group['field']};
                                            $checked = in_array($value, (array)request($group['field']));
                                        @endphp
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="{{ $group['field'] }}[]" value="{{ $value }}" id="f_{{ $group['field'] }}_{{ $loop->index }}" {{ $checked ? 'checked' : '' }} onchange="this.form.submit()">
                                            <label class="form-check-label small d-flex justify-content-between" for="f_{{ $group['field'] }}_{{ $loop->index }}">
                                                <span>{{ $value }}</span>
                                                <span class="text-muted">({{ $item->count }})</span>
                                            </label>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            @endif
                        @endforeach

                        <!-- RunFlat Special -->
                        @if($runflats->count() > 0)
                        <div class="mb-4">
                            <h6 class="fw-bold mb-2">RunFlat</h6>
                            @foreach($runflats as $item)
                                @php
                                    $label = $item->runflat ? 'Oui' : 'Non';
                                    $checked = in_array($item->runflat, (array)request('runflat'));
                                @endphp
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="runflat[]" value="{{ $item->runflat }}" id="f_runflat_{{ $label }}" {{ $checked ? 'checked' : '' }} onchange="this.form.submit()">
                                    <label class="form-check-label small d-flex justify-content-between" for="f_runflat_{{ $label }}">
                                        <span>{{ $label }}</span>
                                        <span class="text-muted">({{ $item->count }})</span>
                                    </label>
                                </div>
                            @endforeach
                        </div>
                        @endif

                        <div class="d-grid mt-4">
                            <button type="submit" class="btn btn-primary rounded-pill">Appliquer</button>
                            <a href="{{ url()->current() }}" class="btn btn-link btn-sm text-muted mt-2">Réinitialiser</a>
                        </div>
                    </form>
                </div>
            </div>
        </aside>

        <!-- Product Grid -->
        <main class="col-lg-9">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h4 class="fw-bold mb-0">Résultats ({{ $products->total() }})</h4>
                
                <!-- Filters and Sort -->
                <div class="d-flex gap-2">
                    <!-- Category Filter -->
                    <div class="dropdown">
                        <button class="btn btn-outline-primary dropdown-toggle rounded-pill btn-sm" type="button" data-bs-toggle="dropdown">
                            <i class="bi bi-funnel me-1"></i>
                            {{ isset($category) ? $category->name : 'Toutes catégories' }}
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end shadow-sm border-0">
                            <li><a class="dropdown-item {{ !request('category_id') && !isset($category) ? 'active' : '' }}" href="{{ route('products.index') }}">Toutes catégories</a></li>
                            <li><hr class="dropdown-divider"></li>
                            @foreach($categories as $cat)
                                <li>
                                    <a class="dropdown-item {{ (isset($category) && $category->id == $cat->id) || request('category_id') == $cat->id ? 'active' : '' }}" 
                                       href="{{ route('category.show', $cat->slug) }}">
                                        {{ $cat->name }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                    
                    <!-- Sort -->
                    <div class="dropdown">
                        <button class="btn btn-outline-secondary dropdown-toggle rounded-pill btn-sm" type="button" data-bs-toggle="dropdown">
                            <i class="bi bi-sort-down me-1"></i> Trier par
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end shadow-sm border-0">
                            <li><a class="dropdown-item" href="{{ request()->fullUrlWithQuery(['sort' => 'newest']) }}">Nouveautés</a></li>
                            <li><a class="dropdown-item" href="{{ request()->fullUrlWithQuery(['sort' => 'price_asc']) }}">Prix croissant</a></li>
                            <li><a class="dropdown-item" href="{{ request()->fullUrlWithQuery(['sort' => 'price_desc']) }}">Prix décroissant</a></li>
                            <li><a class="dropdown-item" href="{{ request()->fullUrlWithQuery(['sort' => 'name_asc']) }}">Nom (A-Z)</a></li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="row g-3">
                @forelse($products as $product)
                <div class="col-md-4 col-sm-6">
                    <div class="card h-100 border-0 shadow-sm rounded-4 overflow-hidden product-card-hover text-center">
                        <div class="position-relative">
                            @if($product->en_stock <= 0)
                                <div class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center bg-white bg-opacity-75" style="z-index: 2;">
                                    <span class="badge bg-danger rounded-pill px-3 py-2 shadow">Rupture de stock</span>
                                </div>
                            @endif

                            <div class="p-3">
                                @if($product->image && Storage::disk('public')->exists('pneus/' . $product->image))
                                    <img src="{{ asset('storage/pneus/' . $product->image) }}" class="img-fluid rounded-3" alt="{{ $product->name }}" style="height: 160px; object-fit: contain;">
                                @else
                                    <div class="bg-light d-flex align-items-center justify-content-center rounded-3" style="height: 160px;">
                                        <i class="bi bi-image text-secondary display-4"></i>
                                    </div>
                                @endif
                            </div>
                            
                            <div class="position-absolute top-0 end-0 p-3">
                                @if($product->prix_ancien)
                                    <span class="badge bg-danger rounded-pill shadow-sm">Promo</span>
                                @endif
                            </div>
                        </div>
                        
                        <div class="card-body pt-0 px-3 pb-3">
                            <p class="text-primary fw-bold small mb-1">{{ $product->marque }}</p>
                            <h6 class="card-title fw-bold text-dark text-truncate mb-2">{{ $product->name }}</h6>
                            
                            <div class="mb-2">
                                @if($product->dimension)
                                    <span class="badge bg-light text-dark border-0 rounded-pill px-2 py-1 small fw-semibold">
                                        {{ $product->dimension }}
                                    </span>
                                @endif
                            </div>

                            <div class="d-flex justify-content-center align-items-baseline mb-3">
                                @if($product->prix_ancien)
                                    <span class="text-muted text-decoration-line-through small me-2">{{ $product->prix_ancien }}</span>
                                @endif
                                <span class="h5 fw-bold text-primary mb-0">{{ $product->prix_actuel }} MAD</span>
                            </div>

                            <div class="d-grid gap-2">
                                <a href="{{ route('products.show', $product->id) }}" class="btn btn-outline-dark rounded-pill btn-sm">Détails</a>
                                @if($product->en_stock > 0)
                                <form action="{{ route('cart.add', $product->id) }}" method="POST">
                                    @csrf
                                    <input type="hidden" name="quantite" value="1">
                                    <button type="submit" class="btn btn-primary w-100 rounded-pill btn-sm shadow-sm py-2">
                                        <i class="bi bi-cart-plus me-1"></i> Ajouter
                                    </button>
                                </form>
                                @else
                                <button class="btn btn-secondary w-100 rounded-pill btn-sm py-2" disabled>Indisponible</button>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                @empty
                <div class="col-12 py-5 text-center">
                    <div class="mb-4">
                        <i class="bi bi-search text-muted display-1"></i>
                    </div>
                    <h4 class="text-muted">Aucun résultat trouvé</h4>
                    <p class="text-secondary">Essayez de modifier vos filtres.</p>
                    <a href="{{ url()->current() }}" class="btn btn-outline-primary mt-2 rounded-pill">Réinitialiser les filtres</a>
                </div>
                @endforelse
            </div>

            <!-- Pagination -->
            <div class="mt-5 pagination-container">
                <div class="d-flex flex-column flex-md-row justify-content-between align-items-center gap-3">
                    <div class="text-secondary small fw-medium">
                        Articles {{ $products->firstItem() }}-{{ $products->lastItem() }} sur {{ $products->total() }}
                    </div>
                    <div>
                        {{ $products->links() }}
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>

<style>
    .product-card-hover {
        transition: all 0.3s cubic-bezier(.25,.8,.25,1);
    }
    .product-card-hover:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1) !important;
    }
    .filter-group::-webkit-scrollbar {
        width: 4px;
    }
    .pagination-container nav p {
        display: none !important;
    }
    .pagination-container {
        background-color: #f9fafb;
        padding: 1rem 1.5rem;
        border: 1px solid #e5e7eb;
        border-radius: 0.5rem;
    }
    .pagination {
        margin-bottom: 0;
    }
    .pagination .page-link {
        color: #374151;
        border: 1px solid #d1d5db;
        margin: 0 2px;
        padding: 0.4rem 0.8rem;
        font-size: 0.9rem;
        border-radius: 4px !important;
        transition: all 0.2s ease;
    }
    .pagination .page-item.active .page-link {
        background-color: #0d6efd !important; /* Bootstrap Primary Blue */
        border-color: #0d6efd !important;
        color: white !important;
        box-shadow: 0 2px 4px rgba(13, 110, 253, 0.2);
    }
    .pagination .page-link:hover {
        background-color: #f3f4f6;
        color: #111827;
    }
</style>
@endsection
