@extends('layouts.app')

@section('content')
<div class="container py-5">
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">Accueil</a></li>
            <li class="breadcrumb-item"><a href="{{ route('products.index') }}">Boutique</a></li>
            @if($product->category)
                <li class="breadcrumb-item"><a href="{{ route('category.show', $product->category->slug) }}">{{ $product->category->name }}</a></li>
            @endif
            <li class="breadcrumb-item active" aria-current="page">{{ $product->name }}</li>
        </ol>
    </nav>

    <div class="row g-5">
        <div class="col-md-6">
            <!-- Product Image Section -->
            <div class="card border-0 shadow-sm rounded-4 overflow-hidden bg-white">
                <div class="card-body p-4 text-center position-relative">
                    @if($product->en_stock <= 0)
                        <span class="badge bg-danger position-absolute top-0 start-0 m-4 px-4 py-2 rounded-pill shadow" style="font-size: 1rem; z-index: 2;">Rupture de stock</span>
                    @endif

                    @if($product->image && Storage::disk('public')->exists('pneus/' . $product->image))
                        <img src="{{ asset('storage/pneus/' . $product->image) }}" alt="{{ $product->name }}" class="img-fluid rounded-3" style="max-height: 500px; @if($product->en_stock <= 0) opacity: 0.6; @endif">
                    @else
                        <div class="d-flex align-items-center justify-content-center bg-light rounded-3 shadow-inner" style="height: 400px;">
                            <i class="bi bi-image text-secondary display-1"></i>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Description Section -->
            @if($product->description)
            <div class="mt-5">
                <h4 class="fw-bold mb-3">Description</h4>
                <div class="text-muted leading-relaxed">
                    {!! nl2br(e($product->description)) !!}
                </div>
            </div>
            @endif
        </div>

        <div class="col-md-6">
            <div class="ps-md-4">
                <h6 class="text-primary fw-bold text-uppercase mb-2 tracking-wider">{{ $product->marque }}</h6>
                <h1 class="display-5 fw-bold text-dark mb-4">{{ $product->name }}</h1>
                
                <div class="d-flex align-items-center mb-4">
                    <div class="me-4 border-end pe-4">
                        @if($product->prix_ancien)
                            <p class="text-muted text-decoration-line-through mb-0 small">Prix original: {{ $product->prix_ancien }} MAD</p>
                        @endif
                        <h2 class="text-primary fw-bold mb-0">{{ $product->prix_actuel }} MAD</h2>
                    </div>
                    <div>
                        <p class="mb-0 fw-semibold">État du stock</p>
                        @if($product->en_stock > 0)
                            <span class="text-success"><i class="bi bi-check-circle-fill me-1"></i> {{ $product->en_stock }} disponibles</span>
                        @else
                            <span class="text-danger"><i class="bi bi-x-circle-fill me-1"></i> Épuisé</span>
                        @endif
                    </div>
                </div>

                <hr class="my-4 opacity-10">

                @if($product->en_stock > 0)
                <div class="card border-0 bg-light rounded-4 shadow-sm mb-5">
                    <div class="card-body p-4">
                        <form action="{{ route('cart.add', $product->id) }}" method="POST">
                            @csrf
                            <div class="row align-items-end g-3">
                                <div class="col-4">
                                    <label for="quantite" class="form-label small fw-bold">Quantité</label>
                                    <input type="number" class="form-control border-0 rounded-3 py-2" name="quantite" id="quantite" value="1" min="1" max="{{ $product->en_stock }}">
                                </div>
                                <div class="col-8">
                                    <button type="submit" class="btn btn-primary w-100 rounded-pill py-2 shadow transition-all">
                                        <i class="bi bi-cart-plus me-2"></i> Ajouter au panier
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                @endif

                <!-- Technical Specs for Tires -->
                @if($product->category && $product->category->slug === 'pneus')
                <div class="mt-5">
                    <h5 class="fw-bold mb-4 d-flex align-items-center">
                        <span class="bg-primary p-1 rounded-2 me-2" style="width: 8px; height: 24px; display: inline-block;"></span>
                        Caractéristiques techniques
                    </h5>
                    
                    <div class="row g-3">
                        <div class="col-6">
                            <div class="p-3 bg-light rounded-4 border-0">
                                <small class="text-muted d-block mb-1">Dimension complète</small>
                                <span class="fw-bold text-dark">{{ $product->dimension }}</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="p-3 bg-light rounded-4 border-0">
                                <small class="text-muted d-block mb-1">Saison</small>
                                <span class="fw-bold text-dark">
                                    @if($product->saison === 'Été') <i class="bi bi-brightness-high text-warning"></i> @elseif($product->saison === 'Hiver') <i class="bi bi-snow text-info"></i> @else <i class="bi bi-cloud-sun text-secondary"></i> @endif
                                    {{ $product->saison }}
                                </span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="p-3 bg-light rounded-4 border-0">
                                <small class="text-muted d-block mb-1">Indices Charge / Vitesse</small>
                                <span class="fw-bold text-dark">{{ $product->charge_index }} {{ $product->vitesse_index }} @if($product->vitesse_kmh)({{ $product->vitesse_kmh }} km/h)@endif</span>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="p-3 bg-light rounded-4 border-0">
                                <small class="text-muted d-block mb-1">Structure</small>
                                <span class="fw-bold text-dark">{{ $product->runflat ? 'RunFlat' : ($product->renforce ? 'Renforcé (XL)' : 'Standard') }}</span>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="p-3 bg-light rounded-4 border-0 text-center">
                                <small class="text-muted d-block mb-1">Largeur</small>
                                <span class="fw-bold text-dark">{{ $product->largeur ?? '-' }}</span>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="p-3 bg-light rounded-4 border-0 text-center">
                                <small class="text-muted d-block mb-1">Hauteur</small>
                                <span class="fw-bold text-dark">{{ $product->hauteur ?? '-' }}</span>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="p-3 bg-light rounded-4 border-0 text-center">
                                <small class="text-muted d-block mb-1">Diamètre</small>
                                <span class="fw-bold text-dark">{{ $product->diametre ?? '-' }}</span>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="p-3 bg-light rounded-4 border-0">
                                <small class="text-muted d-block mb-1">Type de véhicule</small>
                                <span class="fw-bold text-dark">{{ $product->type_pneu ?? '-' }}</span>
                            </div>
                        </div>
                    </div>

                    <div class="mt-4 pt-3 border-top">
                        <div class="row g-2">
                            @if($product->dot_annee)
                            <div class="col-auto">
                                <span class="badge bg-white border text-secondary px-3 py-2 rounded-pill fw-normal">DOT : <strong>{{ $product->dot_annee }}</strong></span>
                            </div>
                            @endif
                            @if($product->pays_fabrication)
                            <div class="col-auto">
                                <span class="badge bg-white border text-secondary px-3 py-2 rounded-pill fw-normal">Origine : <strong>{{ $product->pays_fabrication }}</strong></span>
                            </div>
                            @endif
                            @if($product->sku)
                            <div class="col-auto">
                                <span class="badge bg-white border text-secondary px-3 py-2 rounded-pill fw-normal">SKU : <strong>{{ $product->sku }}</strong></span>
                            </div>
                            @endif
                        </div>
                    </div>

                    <!-- European Labels Section -->
                    <div class="mt-5 pt-4 border-top">
                        <h5 class="fw-bold mb-4 d-flex align-items-center">
                            <i class="bi bi-info-circle text-primary me-2"></i> Étiq. Européenne
                        </h5>
                        <div class="row g-3">
                            <div class="col-4 text-center">
                                <div class="p-3 border border-2 rounded-4 bg-white shadow-sm h-100 d-flex flex-column align-items-center justify-content-center">
                                    <div class="small text-muted mb-2 fw-semibold">Carburant</div>
                                    <div class="mb-2">
                                        <i class="bi bi-fuel-pump text-success fs-1"></i>
                                    </div>
                                    <div class="display-6 fw-black text-success">{{ $product->conso_carburant }}</div>
                                </div>
                            </div>
                            <div class="col-4 text-center">
                                <div class="p-3 border border-2 rounded-4 bg-white shadow-sm h-100 d-flex flex-column align-items-center justify-content-center">
                                    <div class="small text-muted mb-2 fw-semibold">Sol Mouillé</div>
                                    <div class="mb-2">
                                        <i class="bi bi-cloud-rain-heavy text-primary fs-1"></i>
                                    </div>
                                    <div class="display-6 fw-black text-primary">{{ $product->adherence_sol_mouille }}</div>
                                </div>
                            </div>
                            <div class="col-4 text-center">
                                <div class="p-3 border border-2 rounded-4 bg-white shadow-sm h-100 d-flex flex-column align-items-center justify-content-center">
                                    <div class="small text-muted mb-2 fw-semibold">Bruit</div>
                                    <div class="mb-2">
                                        <i class="bi bi-volume-up text-dark fs-1"></i>
                                    </div>
                                    <div class="display-6 fw-black text-dark">
                                        {{ $product->bruit_externe_db }} 
                                        @if($product->bruit_externe_db)
                                            <small class="fs-6 fw-normal">dB</small>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                @else
                <!-- For General Products -->
                <div class="mt-5">
                    <div class="row g-3">
                        @if($product->sku)
                        <div class="col-12">
                            <div class="p-3 bg-light rounded-4 border-0">
                                <small class="text-muted d-block mb-1">Référence (SKU)</small>
                                <span class="fw-bold text-dark">{{ $product->sku }}</span>
                            </div>
                        </div>
                        @endif
                        @if($product->pays_fabrication)
                        <div class="col-12">
                            <div class="p-3 bg-light rounded-4 border-0">
                                <small class="text-muted d-block mb-1">Origine</small>
                                <span class="fw-bold text-dark">{{ $product->pays_fabrication }}</span>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
                @endif
                
                <div class="mt-5">
                    <p class="text-muted x-small d-flex align-items-center">
                        <i class="bi bi-shield-check me-2 text-success fs-5"></i>
                        Paiement sécurisé et garantie constructeur sur tous nos produits.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .tracking-wider { letter-spacing: 0.1em; }
    .leading-relaxed { line-height: 1.8; }
    .transition-all { transition: all 0.3s ease; }
    .transition-all:hover { filter: brightness(1.1); transform: translateY(-2px); }
    .x-small { font-size: 0.85rem; }
    .fw-black { font-weight: 900; }
</style>
@endsection
