@extends('layouts.app')

@section('content')
<div class="container py-5">
    <div class="mb-5">
        <h1 class="fw-black text-dark mb-1">Mon Profil</h1>
        <p class="text-muted">Gérez vos informations personnelles et de contact.</p>
    </div>

    <div class="row g-4 justify-content-center">
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm rounded-4 overflow-hidden mb-4">
                <div class="card-header bg-white py-4 px-4 border-0">
                    <h5 class="fw-bold text-dark mb-0 d-flex align-items-center">
                        <i class="bi bi-person-circle text-primary me-2"></i> Informations Publiques
                    </h5>
                </div>
                <div class="card-body p-4 pt-0">
                    <form action="{{ route('profile.update') }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="nom" class="form-control border-0 bg-light rounded-3 @error('nom') is-invalid @enderror" id="nom" value="{{ old('nom', $user->nom) }}" placeholder="Nom" required>
                                    <label for="nom">Nom</label>
                                    @error('nom')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="prenom" class="form-control border-0 bg-light rounded-3 @error('prenom') is-invalid @enderror" id="prenom" value="{{ old('prenom', $user->prenom) }}" placeholder="Prénom" required>
                                    <label for="prenom">Prénom</label>
                                    @error('prenom')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-floating mb-3">
                            <input type="email" name="email" class="form-control border-0 bg-light rounded-3 @error('email') is-invalid @enderror" id="email" value="{{ old('email', $user->email) }}" placeholder="Email" required pattern="[a-z0-9._%+-]+@gmail\.com$" title="L'adresse email doit se terminer par @gmail.com">
                            <label for="email">Adresse Email</label>
                            @error('email')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <div class="form-floating mb-3">
                            <input type="text" name="telephone" class="form-control border-0 bg-light rounded-3 @error('telephone') is-invalid @enderror" id="tel" value="{{ old('telephone', $user->telephone) }}" placeholder="Téléphone" required maxlength="10" minlength="10" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10)" title="Le numéro doit contenir exactement 10 chiffres">
                            <label for="tel">Téléphone</label>
                            @error('telephone')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <div class="form-floating mb-4">
                            <textarea name="adresse" class="form-control border-0 bg-light rounded-3" style="height: 100px" id="addr" placeholder="Adresse" required>{{ old('adresse', $user->adresse) }}</textarea>
                            <label for="addr">Adresse complète</label>
                            @error('adresse')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <h6 class="fw-bold text-muted text-uppercase small mb-3 border-top pt-4">Informations d'Entreprise</h6>
                        
                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="nom_entreprise" class="form-control border-0 bg-light rounded-3" id="entreprise" value="{{ old('nom_entreprise', $user->nom_entreprise) }}" placeholder="Nom Entreprise">
                                    <label for="entreprise">Nom de l'entreprise</label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="ice" class="form-control border-0 bg-light rounded-3" id="ice" value="{{ old('ice', $user->ice) }}" placeholder="ICE">
                                    <label for="ice">ICE</label>
                                </div>
                            </div>
                        </div>

                        <h6 class="fw-bold text-muted text-uppercase small mb-3 border-top pt-4">Changer de Mot de Passe</h6>
                        
                        <div class="form-floating mb-3">
                            <input type="password" name="current_password" class="form-control border-0 bg-light rounded-3 @error('current_password') is-invalid @enderror" id="curr_pass" placeholder="Ancien mot de passe">
                            <label for="curr_pass">Mot de passe actuel (nécessaire pour changer)</label>
                            @error('current_password')<div class="invalid-feedback">{{ $message }}</div>@enderror
                        </div>

                        <div class="row g-3 mb-4">
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="password" name="new_password" class="form-control border-0 bg-light rounded-3 @error('new_password') is-invalid @enderror" id="new_pass" placeholder="Nouveau mot de passe">
                                    <label for="new_pass">Nouveau mot de passe</label>
                                    @error('new_password')<div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="password" name="new_password_confirmation" class="form-control border-0 bg-light rounded-3" id="conf_pass" placeholder="Confirmer">
                                    <label for="conf_pass">Confirmer le nouveau passe</label>
                                </div>
                            </div>
                        </div>

                        <div class="d-flex justify-content-end">
                            <button type="submit" class="btn btn-primary rounded-pill px-5 py-3 fw-bold shadow-sm hover-elevate">
                                <i class="bi bi-check2-circle me-2"></i> Enregistrer les modifications
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .fw-black { font-weight: 900; }
    .hover-elevate { transition: all 0.2s ease; }
    .hover-elevate:hover { transform: translateY(-2px); box-shadow: 0 4px 12px rgba(0,0,0,0.1) !important; }
</style>
@endsection
